/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.SRM_S07_GENERAL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S07_LOCATION_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S07_PERSONNEL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S07_SERVICE;
import ca.uhn.hl7v2.model.v23.segment.RGS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRM_S07_RESOURCES
extends AbstractGroup {
    public SRM_S07_RESOURCES(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RGS.class, true, false, false);
            this.add(SRM_S07_SERVICE.class, false, true, false);
            this.add(SRM_S07_GENERAL_RESOURCE.class, false, true, false);
            this.add(SRM_S07_LOCATION_RESOURCE.class, false, true, false);
            this.add(SRM_S07_PERSONNEL_RESOURCE.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SRM_S07_RESOURCES - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public RGS getRGS() {
        RGS retVal = this.getTyped("RGS", RGS.class);
        return retVal;
    }

    public SRM_S07_SERVICE getSERVICE() {
        SRM_S07_SERVICE retVal = this.getTyped("SERVICE", SRM_S07_SERVICE.class);
        return retVal;
    }

    public SRM_S07_SERVICE getSERVICE(int rep) {
        SRM_S07_SERVICE retVal = this.getTyped("SERVICE", rep, SRM_S07_SERVICE.class);
        return retVal;
    }

    public int getSERVICEReps() {
        return this.getReps("SERVICE");
    }

    public List<SRM_S07_SERVICE> getSERVICEAll() throws HL7Exception {
        return this.getAllAsList("SERVICE", SRM_S07_SERVICE.class);
    }

    public void insertSERVICE(SRM_S07_SERVICE structure, int rep) throws HL7Exception {
        super.insertRepetition("SERVICE", structure, rep);
    }

    public SRM_S07_SERVICE insertSERVICE(int rep) throws HL7Exception {
        return (SRM_S07_SERVICE)super.insertRepetition("SERVICE", rep);
    }

    public SRM_S07_SERVICE removeSERVICE(int rep) throws HL7Exception {
        return (SRM_S07_SERVICE)super.removeRepetition("SERVICE", rep);
    }

    public SRM_S07_GENERAL_RESOURCE getGENERAL_RESOURCE() {
        SRM_S07_GENERAL_RESOURCE retVal = this.getTyped("GENERAL_RESOURCE", SRM_S07_GENERAL_RESOURCE.class);
        return retVal;
    }

    public SRM_S07_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) {
        SRM_S07_GENERAL_RESOURCE retVal = this.getTyped("GENERAL_RESOURCE", rep, SRM_S07_GENERAL_RESOURCE.class);
        return retVal;
    }

    public int getGENERAL_RESOURCEReps() {
        return this.getReps("GENERAL_RESOURCE");
    }

    public List<SRM_S07_GENERAL_RESOURCE> getGENERAL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("GENERAL_RESOURCE", SRM_S07_GENERAL_RESOURCE.class);
    }

    public void insertGENERAL_RESOURCE(SRM_S07_GENERAL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("GENERAL_RESOURCE", structure, rep);
    }

    public SRM_S07_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }

    public SRM_S07_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }

    public SRM_S07_LOCATION_RESOURCE getLOCATION_RESOURCE() {
        SRM_S07_LOCATION_RESOURCE retVal = this.getTyped("LOCATION_RESOURCE", SRM_S07_LOCATION_RESOURCE.class);
        return retVal;
    }

    public SRM_S07_LOCATION_RESOURCE getLOCATION_RESOURCE(int rep) {
        SRM_S07_LOCATION_RESOURCE retVal = this.getTyped("LOCATION_RESOURCE", rep, SRM_S07_LOCATION_RESOURCE.class);
        return retVal;
    }

    public int getLOCATION_RESOURCEReps() {
        return this.getReps("LOCATION_RESOURCE");
    }

    public List<SRM_S07_LOCATION_RESOURCE> getLOCATION_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("LOCATION_RESOURCE", SRM_S07_LOCATION_RESOURCE.class);
    }

    public void insertLOCATION_RESOURCE(SRM_S07_LOCATION_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("LOCATION_RESOURCE", structure, rep);
    }

    public SRM_S07_LOCATION_RESOURCE insertLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_LOCATION_RESOURCE)super.insertRepetition("LOCATION_RESOURCE", rep);
    }

    public SRM_S07_LOCATION_RESOURCE removeLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_LOCATION_RESOURCE)super.removeRepetition("LOCATION_RESOURCE", rep);
    }

    public SRM_S07_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() {
        SRM_S07_PERSONNEL_RESOURCE retVal = this.getTyped("PERSONNEL_RESOURCE", SRM_S07_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public SRM_S07_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) {
        SRM_S07_PERSONNEL_RESOURCE retVal = this.getTyped("PERSONNEL_RESOURCE", rep, SRM_S07_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public int getPERSONNEL_RESOURCEReps() {
        return this.getReps("PERSONNEL_RESOURCE");
    }

    public List<SRM_S07_PERSONNEL_RESOURCE> getPERSONNEL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("PERSONNEL_RESOURCE", SRM_S07_PERSONNEL_RESOURCE.class);
    }

    public void insertPERSONNEL_RESOURCE(SRM_S07_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PERSONNEL_RESOURCE", structure, rep);
    }

    public SRM_S07_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }

    public SRM_S07_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S07_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }
}

