/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_FILLER;
import ca.uhn.hl7v2.model.v22.datatype.CM_INTERNAL_LOCATION;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FT1
extends AbstractSegment {
    public FT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - financial transaction");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction ID");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Transaction batch ID");
            this.add(DT.class, true, 1, 8, new Object[]{this.getMessage()}, "Transaction date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Transaction posting date");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(17)}, "Transaction type");
            this.add(CE.class, true, 1, 20, new Object[]{this.getMessage()}, "Transaction code");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction description");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction description - alternate");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Transaction quantity");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction amount - extended");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction amount - unit");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Department code");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "Insurance plan ID");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Insurance amount");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(24)}, "Fee schedule");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient type");
            this.add(CE.class, false, 0, 8, new Object[]{this.getMessage()}, "Diagnosis code");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Performed by code");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Ordered by code");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Unit cost");
            this.add(CM_FILLER.class, false, 1, 75, new Object[]{this.getMessage()}, "Filler Order Number");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDFinancialTransaction() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getFt11_SetIDFinancialTransaction() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getTransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getFt12_TransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getFt13_TransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public DT getTransactionDate() {
        DT retVal = (DT)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getFt14_TransactionDate() {
        DT retVal = (DT)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getTransactionPostingDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getFt15_TransactionPostingDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getTransactionType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getFt16_TransactionType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getTransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getFt17_TransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getTransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getFt18_TransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getTransactionDescriptionAlternate() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getFt19_TransactionDescriptionAlternate() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getTransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getFt110_TransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getTransactionAmountExtended() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getFt111_TransactionAmountExtended() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getTransactionAmountUnit() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getFt112_TransactionAmountUnit() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getDepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getFt113_DepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getInsurancePlanID() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getFt114_InsurancePlanID() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getInsuranceAmount() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getFt115_InsuranceAmount() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getAssignedPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(16, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getFt116_AssignedPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getFeeSchedule() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getFt117_FeeSchedule() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getFt118_PatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public CE[] getDiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public CE[] getFt119_DiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public int getDiagnosisCodeReps() {
        return this.getReps(19);
    }

    public CE getDiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public CE getFt119_DiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public int getFt119_DiagnosisCodeReps() {
        return this.getReps(19);
    }

    public CE insertDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE insertFt119_DiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE removeDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public CE removeFt119_DiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public CN getPerformedByCode() {
        CN retVal = (CN)this.getTypedField(20, 0);
        return retVal;
    }

    public CN getFt120_PerformedByCode() {
        CN retVal = (CN)this.getTypedField(20, 0);
        return retVal;
    }

    public CN getOrderedByCode() {
        CN retVal = (CN)this.getTypedField(21, 0);
        return retVal;
    }

    public CN getFt121_OrderedByCode() {
        CN retVal = (CN)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getUnitCost() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getFt122_UnitCost() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public CM_FILLER getFillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(23, 0);
        return retVal;
    }

    public CM_FILLER getFt123_FillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(23, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DT(this.getMessage());
            }
            case 4: {
                return new DT(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(17));
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(72));
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(24));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new CN(this.getMessage());
            }
            case 20: {
                return new CN(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new CM_FILLER(this.getMessage());
            }
        }
        return null;
    }
}

