/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.SuperStructure;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.util.StringUtil;
import ca.uhn.hl7v2.util.Terser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSuperMessage
extends AbstractMessage
implements SuperStructure {
    private static final Logger ourLog = LoggerFactory.getLogger(AbstractSuperMessage.class);
    private Map<String, Set<String>> myChildNameToStructures = new HashMap<String, Set<String>>();
    private String myName;

    public AbstractSuperMessage(ModelClassFactory theFactory) {
        super(theFactory);
    }

    protected void addSuperstructureApplication(String theChild, String theStructure) {
        StringUtil.validateNotEmpty(theChild);
        StringUtil.validateNotEmpty(theStructure);
        if (!this.myChildNameToStructures.containsKey(theChild)) {
            this.myChildNameToStructures.put(theChild, new HashSet());
        }
        this.myChildNameToStructures.get(theChild).add(theStructure);
    }

    @Override
    public String getName() {
        if (StringUtil.isBlank(this.myName)) {
            String retVal = null;
            try {
                Terser t = new Terser(this);
                retVal = t.get("/MSH-9-3");
                if (StringUtil.isBlank(retVal)) {
                    String msh91 = t.get("/MSH-9-1");
                    String msh92 = t.get("/MSH-9-2");
                    if (StringUtil.isNotBlank(msh91) && StringUtil.isNotBlank(msh92)) {
                        retVal = msh91 + "_" + msh92;
                    }
                }
            }
            catch (HL7Exception e) {
                ourLog.debug("Failed to retrieve MSH-9", (Throwable)e);
            }
            return retVal;
        }
        return this.myName;
    }

    @Override
    public Set<String> getStructuresWhichChildAppliesTo(String theChildName) {
        return Collections.unmodifiableSet(this.myChildNameToStructures.get(theChildName));
    }

    public void setName(String theName) {
        this.myName = theName;
    }
}

