/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.persistence.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.inbound.endpoint.persistence.ServiceReferenceHolder;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceService;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceServiceImpl;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="inbound.endpoint.persistence.service", immediate=true)
public class InboundEndpointPersistenceServiceDSComponent {
    private static final Log log = LogFactory.getLog(InboundEndpointPersistenceServiceDSComponent.class);
    private static ConfigurationContextService configContextService = null;

    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activating Inbound Endpoint Persistence service....!");
        }
        BundleContext bndCtx = ctx.getBundleContext();
        bndCtx.registerService(InboundEndpointPersistenceService.class.getName(), (Object)new InboundEndpointPersistenceServiceImpl(), null);
    }

    @Deactivate
    protected void deactivate(ComponentContext compCtx) throws Exception {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the inbound endpoint persistence service");
        }
        ServiceReferenceHolder.getInstance().setRegistrySvc(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the inbound endpoint persistence service");
        }
        ServiceReferenceHolder.getInstance().setRegistrySvc(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        configContextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        configContextService = null;
    }

    public static ConfigurationContextService getConfigContextService() {
        return configContextService;
    }
}

