/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.management;

import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketChannelContext;

public class WebsocketSubscriberPathManager {
    private static WebsocketSubscriberPathManager instance = null;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, List<InboundWebsocketChannelContext>>> inboundSubscriberPathMap = new ConcurrentHashMap();

    public static WebsocketSubscriberPathManager getInstance() {
        if (instance == null) {
            instance = new WebsocketSubscriberPathManager();
        }
        return instance;
    }

    public void addChannelContext(String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        ConcurrentHashMap<String, List<InboundWebsocketChannelContext>> subscriberPathMap = this.inboundSubscriberPathMap.get(inboundName);
        if (subscriberPathMap == null) {
            subscriberPathMap = new ConcurrentHashMap();
            ArrayList<InboundWebsocketChannelContext> listContext = new ArrayList<InboundWebsocketChannelContext>();
            listContext.add(ctx);
            subscriberPathMap.put(subscriberPath, listContext);
            this.inboundSubscriberPathMap.put(inboundName, subscriberPathMap);
        } else {
            List<InboundWebsocketChannelContext> listContext = subscriberPathMap.get(subscriberPath);
            if (listContext == null) {
                listContext = new ArrayList<InboundWebsocketChannelContext>();
                listContext.add(ctx);
                subscriberPathMap.put(subscriberPath, listContext);
            } else {
                listContext.add(ctx);
            }
        }
    }

    public void removeChannelContext(String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        ConcurrentHashMap<String, List<InboundWebsocketChannelContext>> subscriberPathMap = this.inboundSubscriberPathMap.get(inboundName);
        List<InboundWebsocketChannelContext> listContext = subscriberPathMap.get(subscriberPath);
        for (Object context : listContext.toArray()) {
            if (!((InboundWebsocketChannelContext)context).getChannelIdentifier().equals(ctx.getChannelIdentifier())) continue;
            listContext.remove(context);
            break;
        }
        if (listContext.isEmpty()) {
            listContext.clear();
            subscriberPathMap.remove(subscriberPath);
        }
        if (subscriberPathMap.isEmpty()) {
            subscriberPathMap.clear();
            this.inboundSubscriberPathMap.remove(inboundName);
        }
    }

    public List<InboundWebsocketChannelContext> getSubscriberPathChannelContextList(String inboundName, String subscriberPath) {
        return this.inboundSubscriberPathMap.get(inboundName).get(subscriberPath);
    }

    public void broadcastOnSubscriberPath(WebSocketFrame frame, String inboundName, String subscriberPath) {
        List<InboundWebsocketChannelContext> contextList = this.getSubscriberPathChannelContextList(inboundName, subscriberPath);
        for (InboundWebsocketChannelContext context : contextList) {
            WebSocketFrame duplicatedFrame = frame.duplicate();
            context.writeToChannel(duplicatedFrame);
        }
    }

    public void exclusiveBroadcastOnSubscriberPath(WebSocketFrame frame, String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        List<InboundWebsocketChannelContext> contextList = this.getSubscriberPathChannelContextList(inboundName, subscriberPath);
        for (InboundWebsocketChannelContext context : contextList) {
            if (context.getChannelIdentifier().equals(ctx.getChannelIdentifier())) continue;
            WebSocketFrame duplicatedFrame = frame.duplicate();
            context.writeToChannel(duplicatedFrame);
        }
    }
}

