/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.AcknowledgementMode;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQException;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQRecoveryListener;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;

public class RabbitMQConsumer
implements Consumer {
    private static final Log log = LogFactory.getLog(RabbitMQConsumer.class);
    private RabbitMQConnectionFactory rabbitMQConnectionFactory;
    private volatile Map<String, String> rabbitMQProperties = new HashMap<String, String>();
    private RabbitMQInjectHandler injectHandler;
    private Connection connection = null;
    private Channel channel = null;
    private String queueName;
    private long maxDeadLetteredCount;
    private long requeueDelay;
    private boolean autoAck;
    private String inboundName;

    public RabbitMQConsumer(RabbitMQConnectionFactory rabbitMQConnectionFactory, Properties properties, RabbitMQInjectHandler injectHandler) {
        this.rabbitMQConnectionFactory = rabbitMQConnectionFactory;
        this.injectHandler = injectHandler;
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.rabbitMQProperties.put(key.toString(), value.toString())));
    }

    public void execute() {
        try {
            this.initConsumer();
        }
        catch (IOException | RabbitMQException e) {
            log.error((Object)"Error occurred while initializing the consumer.", (Throwable)e);
        }
    }

    private void initConsumer() throws IOException, RabbitMQException {
        if (this.connection == null) {
            this.connection = this.rabbitMQConnectionFactory.createConnection();
        }
        this.channel = this.connection.createChannel();
        ((Recoverable)this.channel).addRecoveryListener((RecoveryListener)new RabbitMQRecoveryListener());
        int qos = NumberUtils.toInt((String)this.rabbitMQProperties.get("rabbitmq.channel.consumer.qos"), (int)0);
        this.channel.basicQos(qos);
        this.queueName = this.rabbitMQProperties.get("rabbitmq.queue.name");
        RabbitMQUtils.declareQueue(this.channel, this.queueName, this.rabbitMQProperties);
        String exchangeName = this.rabbitMQProperties.get("rabbitmq.exchange.name");
        RabbitMQUtils.declareExchange(this.channel, exchangeName, this.rabbitMQProperties);
        this.maxDeadLetteredCount = NumberUtils.toLong((String)this.rabbitMQProperties.get("rabbitmq.message.max.dead.lettered.count"));
        this.requeueDelay = NumberUtils.toLong((String)this.rabbitMQProperties.get("rabbitmq.message.requeue.delay"));
        String consumerTag = this.rabbitMQProperties.get("rabbitmq.consumer.tag");
        this.autoAck = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)this.rabbitMQProperties.get("rabbitmq.queue.auto.ack")), (boolean)true);
        if (StringUtils.isNotEmpty((String)consumerTag)) {
            this.channel.basicConsume(this.queueName, this.autoAck, consumerTag, (Consumer)this);
        } else {
            this.channel.basicConsume(this.queueName, this.autoAck, (Consumer)this);
        }
    }

    public void handleConsumeOk(String consumerTag) {
        log.info((Object)("Start consuming queue: " + this.queueName + " with consumer tag: " + consumerTag + " for inbound endpoint: " + this.inboundName));
    }

    public void handleCancelOk(String consumerTag) {
        log.info((Object)("The consumer with consumer tag: " + consumerTag + " stops listening to new messages."));
    }

    public void handleCancel(String consumerTag) throws IOException {
        log.info((Object)("The consumer with consumer tag: " + consumerTag + " unexpectedly stops listening to new messages."));
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
        if (signal.isInitiatedByApplication()) {
            log.info((Object)("The connection to the messaging server was shut down. Consumer tag: " + consumerTag));
        } else if (signal.getReference() instanceof Channel) {
            int channelNumber = ((Channel)signal.getReference()).getChannelNumber();
            log.info((Object)("The consumer on channel number: " + channelNumber + " with consumer tag: " + consumerTag + " was shut down."));
        } else {
            log.info((Object)("The consumer with consumer tag: " + consumerTag + " was shut down."));
        }
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        AcknowledgementMode acknowledgementMode = this.injectHandler.onMessage(properties, body, this.inboundName);
        switch (acknowledgementMode) {
            case REQUEUE_TRUE: {
                try {
                    Thread.sleep(this.requeueDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.channel.basicReject(envelope.getDeliveryTag(), true);
                break;
            }
            case REQUEUE_FALSE: {
                ArrayList xDeathHeader = (ArrayList)properties.getHeaders().get("x-death");
                if (xDeathHeader != null && xDeathHeader.size() > 0 && this.maxDeadLetteredCount != -1L) {
                    Long count = (Long)((HashMap)xDeathHeader.get(0)).get("count");
                    if (count <= this.maxDeadLetteredCount) {
                        this.channel.basicReject(envelope.getDeliveryTag(), false);
                        log.info((Object)("The rejected message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " is dead-lettered " + count + " time(s)."));
                        break;
                    }
                    this.proceedAfterMaxDeadLetteredCount(envelope, properties, body);
                    break;
                }
                this.channel.basicReject(envelope.getDeliveryTag(), false);
                log.info((Object)("The rejected message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " will discard or dead-lettered."));
                break;
            }
            default: {
                if (this.autoAck) break;
                this.channel.basicAck(envelope.getDeliveryTag(), false);
            }
        }
    }

    private void proceedAfterMaxDeadLetteredCount(Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String routingKey = this.rabbitMQProperties.get("rabbitmq.message.error.queue.routing.key");
        String exchangeName = this.rabbitMQProperties.get("rabbitmq.message.error.exchange.name");
        if (StringUtils.isNotEmpty((String)routingKey) && StringUtils.isNotEmpty((String)exchangeName)) {
            this.channel.basicPublish(exchangeName, routingKey, properties, body);
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            log.info((Object)("The max dead lettered count exceeded. Hence message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " publish to the exchange: " + exchangeName + " with the routing key: " + routingKey + "."));
        } else if (StringUtils.isNotEmpty((String)routingKey) && StringUtils.isEmpty((String)exchangeName)) {
            this.channel.basicPublish("", routingKey, properties, body);
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            log.info((Object)("The max dead lettered count exceeded. Hence message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " publish to the default exchange with the routing key: " + routingKey + "."));
        } else {
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            log.info((Object)("The max dead lettered count exceeded. No 'rabbitmq.message.error.queue.routing.key' specified for publishing the message. Hence the message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " will discard."));
        }
    }

    public void close() {
        this.connection.abort();
        this.channel = null;
        this.connection = null;
    }

    public String getInboundName() {
        return this.inboundName;
    }

    public void setInboundName(String inboundName) {
        this.inboundName = inboundName;
    }
}

