/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.nats.management;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.inbound.endpoint.common.AbstractInboundEndpointManager;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsMessageConsumer;

public class NatsEndpointManager
extends AbstractInboundEndpointManager {
    private static NatsEndpointManager instance = null;
    private NatsMessageConsumer messageConsumer = null;

    public static NatsEndpointManager getInstance() {
        if (instance == null) {
            instance = new NatsEndpointManager();
        }
        return instance;
    }

    @Override
    public boolean startListener(int port, String name, InboundProcessorParams inboundParameters) {
        try {
            this.messageConsumer.initializeConsumer();
        }
        catch (IOException | InterruptedException e) {
            this.messageConsumer.closeConnection();
            throw new SynapseException("An error occurred while connecting to NATS server or consuming messages. ", (Throwable)e);
        }
        catch (Exception e) {
            this.messageConsumer.closeConnection();
            throw new SynapseException("Error while retrieving or injecting NATS message. ", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean startEndpoint(int port, String name, InboundProcessorParams params) {
        if (StringUtils.isEmpty((String)params.getInjectingSeq())) {
            throw new SynapseException("Sequence name not specified. Sequence : " + params.getInjectingSeq());
        }
        Properties natsProperties = params.getProperties();
        this.messageConsumer = new NatsMessageConsumer(natsProperties, name);
        boolean sequential = true;
        String inboundEndpointSequential = natsProperties.getProperty("sequential");
        if (inboundEndpointSequential != null) {
            sequential = Boolean.parseBoolean(inboundEndpointSequential);
        }
        this.messageConsumer.registerHandler(new NatsInjectHandler(params.getInjectingSeq(), params.getOnErrorSeq(), sequential, params.getSynapseEnvironment(), natsProperties.getProperty("content.type")));
        this.messageConsumer.initializeMessageListener();
        this.startListener(port, name, params);
        return false;
    }

    @Override
    public void closeEndpoint(int port) {
        this.messageConsumer.closeConnection();
    }

    public NatsMessageConsumer getMessageConsumer() {
        return this.messageConsumer;
    }
}

