/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttClientManager;

public class MqttConnectionFactory {
    private static final Log log = LogFactory.getLog(MqttConnectionFactory.class);
    private String factoryName;
    private Hashtable<String, String> parameters = new Hashtable();
    private MqttDefaultFilePersistence dataStore;
    private SSLSocketFactory socketFactory;
    private static final int PORT_MIN_BOUND = 0;
    private static final int PORT_MAX_BOUND = 65535;

    public MqttConnectionFactory(Properties passedInParameter) {
        this.factoryName = passedInParameter.getProperty("mqtt.connection.factory");
        try {
            if (passedInParameter.getProperty("mqtt.server.host.name") == null) {
                String msg = "MQTT inbound listener Host Name cannot be empty";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.parameters.put("mqtt.server.host.name", passedInParameter.getProperty("mqtt.server.host.name"));
            if (passedInParameter.getProperty("mqtt.topic.name") == null) {
                String msg = "MQTT inbound listener Subscription Topic Name cannot be empty";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.parameters.put("mqtt.topic.name", passedInParameter.getProperty("mqtt.topic.name"));
            if (passedInParameter.getProperty("mqtt.server.port") == null) {
                String msg = "MQTT inbound listener Port Number cannot be empty";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.validatePortField(passedInParameter.getProperty("mqtt.server.port"));
            this.parameters.put("mqtt.server.port", passedInParameter.getProperty("mqtt.server.port"));
            if (passedInParameter.getProperty("content.type") != null) {
                this.parameters.put("content.type", passedInParameter.getProperty("content.type"));
            } else {
                log.warn((Object)"Default value is used for the parameter : content.type");
            }
            if (passedInParameter.getProperty("mqtt.subscription.qos") == null) {
                this.parameters.put("mqtt.subscription.qos", "1");
                log.warn((Object)"Default value is used for the parameter : mqtt.subscription.qos");
            }
            if (passedInParameter.getProperty("mqtt.subscription.qos") != null) {
                int qos = Integer.parseInt(passedInParameter.getProperty("mqtt.subscription.qos"));
                if (qos == 2 || qos == 1 || qos == 0) {
                    this.parameters.put("mqtt.subscription.qos", passedInParameter.getProperty("mqtt.subscription.qos"));
                } else {
                    this.parameters.put("mqtt.subscription.qos", "1");
                    log.warn((Object)"Default value is used for the parameter : mqtt.subscription.qos");
                }
            }
            if (passedInParameter.getProperty("mqtt.temporary.store.directory") != null) {
                this.parameters.put("mqtt.temporary.store.directory", passedInParameter.getProperty("mqtt.temporary.store.directory"));
            } else {
                log.warn((Object)"Default value is used for the parameter : mqtt.temporary.store.directory");
            }
            if (passedInParameter.getProperty("mqtt.session.clean") != null) {
                this.parameters.put("mqtt.session.clean", passedInParameter.getProperty("mqtt.session.clean"));
            } else {
                log.warn((Object)"Default value is used for the parameter : mqtt.session.clean");
            }
            if (passedInParameter.getProperty("mqtt.ssl.enable") != null) {
                this.parameters.put("mqtt.ssl.enable", passedInParameter.getProperty("mqtt.ssl.enable"));
                if (this.parameters.get("mqtt.ssl.enable").equalsIgnoreCase("true")) {
                    String keyStoreLocation = passedInParameter.getProperty("mqtt.ssl.keystore.location");
                    String keyStoreType = passedInParameter.getProperty("mqtt.ssl.keystore.type");
                    String keyStorePassword = passedInParameter.getProperty("mqtt.ssl.keystore.password");
                    String trustStoreLocation = passedInParameter.getProperty("mqtt.ssl.truststore.location");
                    String trustStoreType = passedInParameter.getProperty("mqtt.ssl.truststore.type");
                    String trustStorePassword = passedInParameter.getProperty("mqtt.ssl.truststore.password");
                    String sslVersion = passedInParameter.getProperty("mqtt.ssl.version");
                    if (StringUtils.isEmpty((String)keyStoreLocation) || StringUtils.isEmpty((String)keyStoreType) || StringUtils.isEmpty((String)keyStorePassword) || StringUtils.isEmpty((String)trustStoreLocation) || StringUtils.isEmpty((String)trustStoreType) || StringUtils.isEmpty((String)trustStorePassword) || StringUtils.isEmpty((String)sslVersion)) {
                        String msg = "Configuration for Truststore and Keystore is insufficient to enable SSL";
                        log.error((Object)msg);
                        throw new SynapseException(msg);
                    }
                    this.socketFactory = this.getSocketFactory(keyStoreLocation, keyStoreType, keyStorePassword, trustStoreLocation, trustStoreType, trustStorePassword, sslVersion);
                }
            } else {
                log.warn((Object)"Default value is used for the parameter : mqtt.ssl.enable");
            }
            if (passedInParameter.getProperty("mqtt.client.id") != null) {
                this.parameters.put("mqtt.client.id", passedInParameter.getProperty("mqtt.client.id"));
            } else {
                log.warn((Object)"Default value is used for the parameter : mqtt.client.id");
            }
            if (passedInParameter.getProperty("mqtt.reconnection.interval") != null) {
                this.parameters.put("mqtt.reconnection.interval", passedInParameter.getProperty("mqtt.reconnection.interval"));
            } else {
                log.warn((Object)"Default value is used for the parameter : mqtt.reconnection.interval");
            }
        }
        catch (Exception ex) {
            log.error((Object)("MQTT connection factory : " + this.factoryName + " failed to initialize the MQTT Inbound configuration properties"), (Throwable)ex);
            throw new SynapseException(ex.getMessage());
        }
    }

    public String getName() {
        return this.factoryName;
    }

    public MqttAsyncClient getMqttAsyncClient(String name) {
        return this.createMqttAsyncClient(name);
    }

    public String getTopic() {
        return this.parameters.get("mqtt.topic.name");
    }

    public String getContent() {
        return this.parameters.get("content.type");
    }

    public String getServerHost() {
        return this.parameters.get("mqtt.server.host.name");
    }

    public String getServerPort() {
        return this.parameters.get("mqtt.server.port");
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.socketFactory;
    }

    public int getReconnectionInterval() {
        if (this.parameters.get("mqtt.reconnection.interval") != null) {
            return Integer.parseInt(this.parameters.get("mqtt.reconnection.interval"));
        }
        return -1;
    }

    private MqttAsyncClient createMqttAsyncClient(String name) {
        MqttClientManager clientManager = MqttClientManager.getInstance();
        String uniqueClientId = this.parameters.get("mqtt.client.id") != null ? this.parameters.get("mqtt.client.id") : MqttAsyncClient.generateClientId();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        int tenantId = carbonContext.getTenantId();
        String inboundIdentifier = clientManager.hasInboundEndpoint(name = clientManager.buildNameIdentifier(name, String.valueOf(tenantId))) ? clientManager.getInboundEndpointIdentifier(name) : clientManager.buildIdentifier(uniqueClientId, this.getServerHost(), this.getServerPort());
        if (clientManager.hasMqttClient(inboundIdentifier)) {
            if (clientManager.hasClientDataStore(inboundIdentifier)) {
                this.dataStore = clientManager.getMqttClientDataStore(inboundIdentifier);
            }
            return clientManager.getMqttClient(inboundIdentifier);
        }
        String sslEnable = this.parameters.get("mqtt.ssl.enable");
        String tmpDir = this.parameters.get("mqtt.temporary.store.directory");
        this.dataStore = null;
        int qos = Integer.parseInt(this.parameters.get("mqtt.subscription.qos".toString()));
        if (qos == 2 || qos == 1) {
            if (tmpDir != null) {
                this.dataStore = new MqttDefaultFilePersistence(tmpDir);
            } else {
                tmpDir = System.getProperty("java.io.tmpdir");
                this.dataStore = new MqttDefaultFilePersistence(tmpDir);
            }
        } else {
            this.dataStore = null;
        }
        String mqttEndpointURL = "tcp://" + this.parameters.get("mqtt.server.host.name") + ":" + this.parameters.get("mqtt.server.port");
        if (sslEnable != null && sslEnable.equalsIgnoreCase("true")) {
            mqttEndpointURL = "ssl://" + this.parameters.get("mqtt.server.host.name") + ":" + this.parameters.get("mqtt.server.port");
        }
        MqttAsyncClient mqttClient = null;
        try {
            mqttClient = new MqttAsyncClient(mqttEndpointURL, uniqueClientId, (MqttClientPersistence)this.dataStore);
            log.info((Object)"Successfully created MQTT client");
        }
        catch (MqttException ex) {
            log.error((Object)"Error while creating the MQTT asynchronous client", (Throwable)ex);
        }
        clientManager.registerInboundEndpoint(name, inboundIdentifier);
        clientManager.registerMqttClient(inboundIdentifier, mqttClient);
        if (this.dataStore != null) {
            clientManager.registerClientDataStore(inboundIdentifier, this.dataStore);
        }
        return mqttClient;
    }

    protected void validatePortField(String port) {
        try {
            int portInteger = Integer.parseInt(port);
            if (0 < portInteger && portInteger < 65535) {
                return;
            }
            String msg = "Server Port number should be bounded to min integer value: 0 and max integer value: 65535";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        catch (NumberFormatException ex) {
            String msg = "Server Port number should not contain any special characters";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    public void shutdown(boolean isClientConnected) {
        if (this.dataStore != null && isClientConnected) {
            try {
                this.dataStore.clear();
                this.dataStore.close();
            }
            catch (MqttPersistenceException ex) {
                log.error((Object)"Error while releasing the resources for data store", (Throwable)ex);
            }
        }
    }

    protected SSLSocketFactory getSocketFactory(String keyStoreLocation, String keyStoreType, String keyStorePassword, String trustStoreLocation, String trustStoreType, String trustStorePassword, String sslVersion) throws Exception {
        char[] keyPassphrase = keyStorePassword.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(keyStoreLocation), keyPassphrase);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyPassphrase);
        char[] trustPassphrase = trustStorePassword.toCharArray();
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        trustStore.load(new FileInputStream(trustStoreLocation), trustPassphrase);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(sslVersion);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext.getSocketFactory();
    }
}

