/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.kafka;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.InjectHandler;

public class KAFKAInjectHandler
implements InjectHandler {
    private static final Log log = LogFactory.getLog(KAFKAInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;
    private String contentType;

    public KAFKAInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment, String contentType) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
        this.contentType = contentType;
    }

    @Override
    public boolean invoke(Object object, String name) {
        byte[] msg = (byte[])object;
        org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
        msgCtx.setProperty("inbound.endpoint.name", (Object)name);
        msgCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + name));
        msgCtx.setProperty("isInbound", (Object)true);
        InboundEndpoint inboundEndpoint = msgCtx.getConfiguration().getInboundEndpoint(name);
        CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
        log.debug((Object)"Processed Kafka Message ");
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        SOAPBuilder builder = null;
        if (this.contentType == null) {
            log.debug((Object)"No content type specified. Using SOAP builder.");
            builder = new SOAPBuilder();
        } else {
            int index = this.contentType.indexOf(59);
            String type = index > 0 ? this.contentType.substring(0, index) : this.contentType;
            try {
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()), (Throwable)axisFault);
            }
            if (builder == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                }
                builder = new SOAPBuilder();
            }
        }
        OMElement documentElement = null;
        AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(msg));
        try {
            documentElement = builder.processDocument((InputStream)in, this.contentType, axis2MsgCtx);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while processing message :: " + axisFault.getMessage()), (Throwable)axisFault);
        }
        try {
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while setting message payload to the message context :: " + axisFault.getMessage()), (Throwable)axisFault);
        }
        if (this.injectingSeq == null || this.injectingSeq.equals("")) {
            log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
            return false;
        }
        SequenceMediator seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq);
        if (seq != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
            }
            if (!seq.isInitialized()) {
                seq.init(this.synapseEnvironment);
            }
            seq.setErrorHandler(this.onErrorSeq);
            this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential);
        } else {
            log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
        }
        return true;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        return msgCtx;
    }
}

