/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.core;

import ca.uhn.hl7v2.HL7Exception;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.passthru.util.BufferFactory;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.context.MLLPContext;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.context.MLLPContextFactory;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.HL7Processor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLPConstants;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLProtocolException;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7MessageUtils;

public class MLLPSourceHandler
implements IOEventDispatch {
    private static final Log log = LogFactory.getLog(MLLPSourceHandler.class);
    private volatile HL7Processor hl7Processor;
    private final ByteBuffer hl7TrailerBuf = ByteBuffer.wrap(MLLPConstants.HL7_TRAILER);
    private BufferFactory bufferFactory;
    private ControlledByteBuffer inputBuffer;
    private ControlledByteBuffer outputBuffer;

    public MLLPSourceHandler() {
    }

    public MLLPSourceHandler(HL7Processor hl7Processor) {
        this.hl7Processor = hl7Processor;
        this.bufferFactory = (BufferFactory)hl7Processor.getInboundParameterMap().get("INBOUND_HL7_BUFFER_FACTORY");
    }

    public void connected(IOSession session) {
        if (session.getAttribute("HL7_MLLP_CONTEXT") == null) {
            session.setAttribute("HL7_MLLP_CONTEXT", (Object)MLLPContextFactory.createMLLPContext(session, this.hl7Processor));
        }
        this.inputBuffer = this.bufferFactory.getBuffer();
        this.outputBuffer = this.bufferFactory.getBuffer();
    }

    public void inputReady(IOSession session) {
        ByteChannel ch = session.channel();
        MLLPContext mllpContext = (MLLPContext)session.getAttribute("HL7_MLLP_CONTEXT");
        this.inputBuffer.clear();
        try {
            int read;
            while ((read = ch.read(this.inputBuffer.getByteBuffer())) > 0) {
                this.inputBuffer.flip();
                try {
                    mllpContext.getCodec().decode(this.inputBuffer.getByteBuffer(), mllpContext);
                }
                catch (MLLProtocolException e) {
                    this.handleException(session, mllpContext, e);
                    this.clearInputBuffers(mllpContext);
                    return;
                }
                catch (HL7Exception e) {
                    this.handleException(session, mllpContext, (Exception)((Object)e));
                    if (mllpContext.isAutoAck()) {
                        mllpContext.setNackMode(true);
                        mllpContext.setHl7Message(HL7MessageUtils.createDefaultNack(e.getMessage()));
                        mllpContext.requestOutput();
                    } else {
                        this.hl7Processor.processError(mllpContext, (Exception)((Object)e));
                    }
                    return;
                }
                catch (IOException e) {
                    this.shutdownConnection(session, mllpContext, e);
                    return;
                }
            }
            if (mllpContext.getCodec().isReadComplete()) {
                if (mllpContext.isAutoAck()) {
                    mllpContext.requestOutput();
                    this.bufferFactory.release(this.inputBuffer);
                    this.inputBuffer = this.bufferFactory.getBuffer();
                }
                try {
                    this.hl7Processor.processRequest(mllpContext);
                }
                catch (Exception e) {
                    this.shutdownConnection(session, mllpContext, e);
                }
            }
            if (read < 0) {
                this.clearInputBuffers(mllpContext);
                session.close();
            }
        }
        catch (IOException e) {
            this.shutdownConnection(session, mllpContext, e);
        }
    }

    private void clearInputBuffers(MLLPContext context) {
        this.bufferFactory.release(this.inputBuffer);
        this.inputBuffer = this.bufferFactory.getBuffer();
        context.reset();
    }

    public void outputReady(IOSession session) {
        MLLPContext mllpContext = (MLLPContext)session.getAttribute("HL7_MLLP_CONTEXT");
        this.writeOut(session, mllpContext);
    }

    private void writeOut(IOSession session, MLLPContext mllpContext) {
        this.outputBuffer.clear();
        try {
            mllpContext.getCodec().encode(this.outputBuffer.getByteBuffer(), mllpContext);
        }
        catch (HL7Exception e) {
            this.shutdownConnection(session, mllpContext, (Exception)((Object)e));
        }
        catch (IOException e) {
            this.shutdownConnection(session, mllpContext, e);
        }
        if (this.outputBuffer == null) {
            this.handleException(session, mllpContext, new MLLProtocolException("HL7 Codec is in an inconsistent state: " + mllpContext.getCodec().getState() + ". Shutting down connection."));
            return;
        }
        try {
            session.channel().write(this.outputBuffer.getByteBuffer());
            if (mllpContext.getCodec().isWriteTrailer()) {
                session.channel().write(this.hl7TrailerBuf);
                this.hl7TrailerBuf.flip();
                mllpContext.getCodec().setState(7);
            }
        }
        catch (IOException e) {
            this.shutdownConnection(session, mllpContext, e);
        }
        if (mllpContext.getCodec().isWriteComplete()) {
            if (mllpContext.isMarkForClose()) {
                this.shutdownConnection(session, mllpContext, null);
            } else {
                this.bufferFactory.release(this.outputBuffer);
                this.outputBuffer = this.bufferFactory.getBuffer();
                mllpContext.setMessageId("RESPONDED");
                mllpContext.reset();
                mllpContext.requestInput();
            }
        }
    }

    public void timeout(IOSession session) {
        MLLPContext mllpContext = (MLLPContext)session.getAttribute("HL7_MLLP_CONTEXT");
        this.shutdownConnection(session, mllpContext, null);
    }

    public void disconnected(IOSession session) {
        MLLPContext mllpContext = (MLLPContext)session.getAttribute("HL7_MLLP_CONTEXT");
        this.shutdownConnection(session, mllpContext, null);
    }

    private void shutdownConnection(IOSession session, MLLPContext mllpContext, Exception e) {
        if (e != null) {
            log.error((Object)"An unexpected error has occurred.");
            this.handleException(session, mllpContext, e);
        }
        this.bufferFactory.release(this.inputBuffer);
        this.bufferFactory.release(this.outputBuffer);
        session.close();
    }

    private void handleException(IOSession session, MLLPContext mllpContext, Exception e) {
        log.error((Object)"Exception caught in I/O handler.", (Throwable)e);
    }
}

