/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.core;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.InboundHL7IOReactor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.management.HL7EndpointManager;

public class InboundHL7Listener
implements InboundRequestProcessor {
    private static final Log log = LogFactory.getLog(InboundHL7Listener.class);
    private int port;
    private InboundProcessorParams params;

    public InboundHL7Listener(InboundProcessorParams params) {
        this.params = params;
    }

    public void init() {
        if (!InboundHL7IOReactor.isStarted()) {
            log.info((Object)"Starting MLLP Transport Reactor");
            try {
                InboundHL7IOReactor.start();
            }
            catch (IOException e) {
                log.error((Object)"MLLP Reactor startup error: ", (Throwable)e);
                return;
            }
        }
        this.start();
    }

    public void start() {
        try {
            this.port = Integer.parseInt(this.params.getProperties().getProperty("inbound.hl7.Port"));
        }
        catch (NumberFormatException e) {
            log.error((Object)("The port specified is of an invalid type: " + this.port + ". Endpoint not started."));
            return;
        }
        HL7EndpointManager.getInstance().startEndpoint(this.port, this.params.getName(), this.params);
    }

    public void destroy() {
        HL7EndpointManager.getInstance().closeEndpoint(this.port);
    }
}

