/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import java.util.Date;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.common.InboundTask;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceServiceDSComponent;
import org.wso2.carbon.mediation.clustering.ClusteringAgentUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class InboundRunner
implements Runnable {
    private InboundTask task;
    private long interval;
    private volatile boolean execute = true;
    private volatile boolean init = false;
    private long lastRuntime;
    private long currentRuntime;
    private long cycleInterval;
    private String tenantDomain;
    private boolean runOnManagerOverride = false;
    private static final String CLUSTERING_PATTERN = "clusteringPattern";
    private static final String CLUSTERING_PATTERN_WORKER_MANAGER = "WorkerManager";
    private static final Log log = LogFactory.getLog(InboundRunner.class);

    public InboundRunner(InboundTask task, long interval, String tenantDomain, boolean mgrOverride) {
        this.task = task;
        this.interval = interval;
        this.tenantDomain = tenantDomain;
        this.runOnManagerOverride = mgrOverride;
    }

    protected void terminate() {
        this.execute = false;
    }

    @Override
    public void run() {
        log.debug((Object)"Starting the Inbound Endpoint.");
        while (!this.init) {
            log.debug((Object)"Waiting for the configuration context to be loaded to run Inbound Endpoint.");
            Boolean isSingleNode = ClusteringAgentUtil.getClusteringAgent() == null;
            if (!isSingleNode.booleanValue()) {
                Parameter clusteringPattern = ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent().getParameter(CLUSTERING_PATTERN);
                Boolean isWorkerManager = clusteringPattern != null && clusteringPattern.getValue() != null && clusteringPattern.getValue().toString().equals(CLUSTERING_PATTERN_WORKER_MANAGER);
                if (!isSingleNode.booleanValue() && !CarbonUtils.isWorkerNode() && !this.runOnManagerOverride && isWorkerManager.booleanValue()) {
                    this.execute = false;
                    log.info((Object)"Inbound EP will not run in manager node. Same will run on worker(s).");
                }
            }
            this.init = true;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unable to sleep the inbound thread for interval of : " + this.interval + "ms."));
            }
        }
        log.debug((Object)"Configuration context loaded. Running the Inbound Endpoint.");
        while (this.execute) {
            ConfigurationContextService configurationContext;
            block11: {
                log.debug((Object)"Executing the Inbound Endpoint.");
                this.lastRuntime = this.getTime();
                try {
                    this.task.taskExecute();
                }
                catch (Exception e) {
                    log.error((Object)"Error executing the inbound endpoint polling cycle.", (Throwable)e);
                }
                this.currentRuntime = this.getTime();
                this.cycleInterval = this.interval - (this.currentRuntime - this.lastRuntime);
                if (this.cycleInterval > 0L) {
                    try {
                        Thread.sleep(this.interval);
                    }
                    catch (InterruptedException e) {
                        if (!log.isDebugEnabled()) break block11;
                        log.debug((Object)("Unable to sleep the inbound thread for interval of : " + this.interval + "ms."));
                    }
                }
            }
            if (this.tenantDomain == null || (configurationContext = InboundEndpointPersistenceServiceDSComponent.getConfigContextService()) == null) continue;
            ConfigurationContext mainConfigCtx = configurationContext.getServerConfigContext();
            TenantAxisUtils.getTenantConfigurationContext((String)this.tenantDomain, (ConfigurationContext)mainConfigCtx);
        }
        log.debug((Object)"Exit the Inbound Endpoint running loop.");
    }

    private Long getTime() {
        return new Date().getTime();
    }
}

