/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T extends Structure> T instantiateStructure(Class<T> theType, Group parent, ModelClassFactory theModelClassFactory) throws HL7Exception {
        try {
            Constructor<T> constructor = theType.getConstructor(Group.class, ModelClassFactory.class);
            Structure message = (Structure)constructor.newInstance(parent, theModelClassFactory);
            return (T)message;
        }
        catch (Exception e) {
            throw new HL7Exception("Failed to instantiate type " + theType.getCanonicalName() + ": ", e);
        }
    }

    public static <T extends Structure> T instantiateMessage(Class<T> theType, ModelClassFactory theModelClassFactory) throws HL7Exception {
        try {
            Constructor<T> constructor = theType.getConstructor(ModelClassFactory.class);
            Structure message = (Structure)constructor.newInstance(theModelClassFactory);
            return (T)message;
        }
        catch (Exception e) {
            throw new HL7Exception("Failed to instantiate type " + theType.getCanonicalName() + ": ", e);
        }
    }

    public static <T> T instantiate(Class<T> theType) throws HL7Exception {
        try {
            return theType.newInstance();
        }
        catch (Exception e) {
            throw new HL7Exception("Failed to instantiate type " + theType.getCanonicalName() + ": ", e);
        }
    }
}

