/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CQ;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.VR;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRD
extends AbstractSegment {
    public QRD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Query Date/Time");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(106)}, "Query Format Code");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(91)}, "Query Priority");
            this.add(ST.class, true, 1, 10, new Object[]{this.getMessage()}, "Query ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(107)}, "Deferred Response Type");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Deferred Response Date/Time");
            this.add(CQ.class, true, 1, 10, new Object[]{this.getMessage()}, "Quantity Limited Request");
            this.add(XCN.class, true, 0, 250, new Object[]{this.getMessage()}, "Who Subject Filter");
            this.add(CE.class, true, 0, 250, new Object[]{this.getMessage()}, "What Subject Filter");
            this.add(CE.class, true, 0, 250, new Object[]{this.getMessage()}, "What Department Data Code");
            this.add(VR.class, false, 0, 20, new Object[]{this.getMessage()}, "What Data Code Value Qual.");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "Query Results Level");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating QRD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TS getQueryDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getQrd1_QueryDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQueryFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getQrd2_QueryFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getQueryPriority() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getQrd3_QueryPriority() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getQueryID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getQrd4_QueryID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getDeferredResponseType() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getQrd5_DeferredResponseType() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDeferredResponseDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getQrd6_DeferredResponseDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getQuantityLimitedRequest() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getQrd7_QuantityLimitedRequest() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN[] getWhoSubjectFilter() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public XCN[] getQrd8_WhoSubjectFilter() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public int getWhoSubjectFilterReps() {
        return this.getReps(8);
    }

    public XCN getWhoSubjectFilter(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getQrd8_WhoSubjectFilter(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getQrd8_WhoSubjectFilterReps() {
        return this.getReps(8);
    }

    public XCN insertWhoSubjectFilter(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertQrd8_WhoSubjectFilter(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeWhoSubjectFilter(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removeQrd8_WhoSubjectFilter(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public CE[] getWhatSubjectFilter() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getQrd9_WhatSubjectFilter() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getWhatSubjectFilterReps() {
        return this.getReps(9);
    }

    public CE getWhatSubjectFilter(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getQrd9_WhatSubjectFilter(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getQrd9_WhatSubjectFilterReps() {
        return this.getReps(9);
    }

    public CE insertWhatSubjectFilter(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertQrd9_WhatSubjectFilter(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeWhatSubjectFilter(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeQrd9_WhatSubjectFilter(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE[] getWhatDepartmentDataCode() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public CE[] getQrd10_WhatDepartmentDataCode() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public int getWhatDepartmentDataCodeReps() {
        return this.getReps(10);
    }

    public CE getWhatDepartmentDataCode(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public CE getQrd10_WhatDepartmentDataCode(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getQrd10_WhatDepartmentDataCodeReps() {
        return this.getReps(10);
    }

    public CE insertWhatDepartmentDataCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE insertQrd10_WhatDepartmentDataCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE removeWhatDepartmentDataCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public CE removeQrd10_WhatDepartmentDataCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public VR[] getWhatDataCodeValueQual() {
        VR[] retVal = (VR[])this.getTypedField(11, new VR[0]);
        return retVal;
    }

    public VR[] getQrd11_WhatDataCodeValueQual() {
        VR[] retVal = (VR[])this.getTypedField(11, new VR[0]);
        return retVal;
    }

    public int getWhatDataCodeValueQualReps() {
        return this.getReps(11);
    }

    public VR getWhatDataCodeValueQual(int rep) {
        VR retVal = (VR)this.getTypedField(11, rep);
        return retVal;
    }

    public VR getQrd11_WhatDataCodeValueQual(int rep) {
        VR retVal = (VR)this.getTypedField(11, rep);
        return retVal;
    }

    public int getQrd11_WhatDataCodeValueQualReps() {
        return this.getReps(11);
    }

    public VR insertWhatDataCodeValueQual(int rep) throws HL7Exception {
        return (VR)super.insertRepetition(11, rep);
    }

    public VR insertQrd11_WhatDataCodeValueQual(int rep) throws HL7Exception {
        return (VR)super.insertRepetition(11, rep);
    }

    public VR removeWhatDataCodeValueQual(int rep) throws HL7Exception {
        return (VR)super.removeRepetition(11, rep);
    }

    public VR removeQrd11_WhatDataCodeValueQual(int rep) throws HL7Exception {
        return (VR)super.removeRepetition(11, rep);
    }

    public ID getQueryResultsLevel() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getQrd12_QueryResultsLevel() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(106));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(91));
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(107));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new CQ(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new VR(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

