/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.DR;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.SAD;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;

public class XAD
extends AbstractComposite {
    private Type[] data;

    public XAD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[14];
        this.data[0] = new SAD(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ID(this.getMessage(), 399);
        this.data[6] = new ID(this.getMessage(), 190);
        this.data[7] = new ST(this.getMessage());
        this.data[8] = new IS(this.getMessage(), 289);
        this.data[9] = new IS(this.getMessage(), 288);
        this.data[10] = new ID(this.getMessage(), 465);
        this.data[11] = new DR(this.getMessage());
        this.data[12] = new TS(this.getMessage());
        this.data[13] = new TS(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public SAD getStreetAddress() {
        return this.getTyped(0, SAD.class);
    }

    public SAD getXad1_StreetAddress() {
        return this.getTyped(0, SAD.class);
    }

    public ST getOtherDesignation() {
        return this.getTyped(1, ST.class);
    }

    public ST getXad2_OtherDesignation() {
        return this.getTyped(1, ST.class);
    }

    public ST getCity() {
        return this.getTyped(2, ST.class);
    }

    public ST getXad3_City() {
        return this.getTyped(2, ST.class);
    }

    public ST getStateOrProvince() {
        return this.getTyped(3, ST.class);
    }

    public ST getXad4_StateOrProvince() {
        return this.getTyped(3, ST.class);
    }

    public ST getZipOrPostalCode() {
        return this.getTyped(4, ST.class);
    }

    public ST getXad5_ZipOrPostalCode() {
        return this.getTyped(4, ST.class);
    }

    public ID getCountry() {
        return this.getTyped(5, ID.class);
    }

    public ID getXad6_Country() {
        return this.getTyped(5, ID.class);
    }

    public ID getAddressType() {
        return this.getTyped(6, ID.class);
    }

    public ID getXad7_AddressType() {
        return this.getTyped(6, ID.class);
    }

    public ST getOtherGeographicDesignation() {
        return this.getTyped(7, ST.class);
    }

    public ST getXad8_OtherGeographicDesignation() {
        return this.getTyped(7, ST.class);
    }

    public IS getCountyParishCode() {
        return this.getTyped(8, IS.class);
    }

    public IS getXad9_CountyParishCode() {
        return this.getTyped(8, IS.class);
    }

    public IS getCensusTract() {
        return this.getTyped(9, IS.class);
    }

    public IS getXad10_CensusTract() {
        return this.getTyped(9, IS.class);
    }

    public ID getAddressRepresentationCode() {
        return this.getTyped(10, ID.class);
    }

    public ID getXad11_AddressRepresentationCode() {
        return this.getTyped(10, ID.class);
    }

    public DR getAddressValidityRange() {
        return this.getTyped(11, DR.class);
    }

    public DR getXad12_AddressValidityRange() {
        return this.getTyped(11, DR.class);
    }

    public TS getEffectiveDate() {
        return this.getTyped(12, TS.class);
    }

    public TS getXad13_EffectiveDate() {
        return this.getTyped(12, TS.class);
    }

    public TS getExpirationDate() {
        return this.getTyped(13, TS.class);
    }

    public TS getXad14_ExpirationDate() {
        return this.getTyped(13, TS.class);
    }
}

