/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.DR;
import ca.uhn.hl7v2.model.v24.datatype.FN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;

public class XCN
extends AbstractComposite {
    private Type[] data;

    public XCN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[18];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 0);
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new HD(this.getMessage());
        this.data[9] = new ID(this.getMessage(), 0);
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ID(this.getMessage(), 0);
        this.data[12] = new IS(this.getMessage(), 0);
        this.data[13] = new HD(this.getMessage());
        this.data[14] = new ID(this.getMessage(), 0);
        this.data[15] = new CE(this.getMessage());
        this.data[16] = new DR(this.getMessage());
        this.data[17] = new ID(this.getMessage(), 0);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        return this.getTyped(0, ST.class);
    }

    public ST getXcn1_IDNumber() {
        return this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return this.getTyped(1, FN.class);
    }

    public FN getXcn2_FamilyName() {
        return this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getXcn3_GivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getXcn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getXcn5_SuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public ST getXcn6_PrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public IS getDegreeEgMD() {
        return this.getTyped(6, IS.class);
    }

    public IS getXcn7_DegreeEgMD() {
        return this.getTyped(6, IS.class);
    }

    public IS getSourceTable() {
        return this.getTyped(7, IS.class);
    }

    public IS getXcn8_SourceTable() {
        return this.getTyped(7, IS.class);
    }

    public HD getAssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public HD getXcn9_AssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public ID getNameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ID getXcn10_NameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ST getIdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ST getXcn11_IdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ID getCodeIdentifyingTheCheckDigitSchemeEmployed() {
        return this.getTyped(11, ID.class);
    }

    public ID getXcn12_CodeIdentifyingTheCheckDigitSchemeEmployed() {
        return this.getTyped(11, ID.class);
    }

    public IS getIdentifierTypeCode() {
        return this.getTyped(12, IS.class);
    }

    public IS getXcn13_IdentifierTypeCode() {
        return this.getTyped(12, IS.class);
    }

    public HD getAssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public HD getXcn14_AssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public ID getNameRepresentationCode() {
        return this.getTyped(14, ID.class);
    }

    public ID getXcn15_NameRepresentationCode() {
        return this.getTyped(14, ID.class);
    }

    public CE getNameContext() {
        return this.getTyped(15, CE.class);
    }

    public CE getXcn16_NameContext() {
        return this.getTyped(15, CE.class);
    }

    public DR getNameValidityRange() {
        return this.getTyped(16, DR.class);
    }

    public DR getXcn17_NameValidityRange() {
        return this.getTyped(16, DR.class);
    }

    public ID getNameAssemblyOrder() {
        return this.getTyped(17, ID.class);
    }

    public ID getXcn18_NameAssemblyOrder() {
        return this.getTyped(17, ID.class);
    }
}

