/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;

public class HD
extends AbstractComposite {
    private Type[] data;

    public HD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new IS(this.getMessage(), 300);
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 301);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getNamespaceID() {
        return this.getTyped(0, IS.class);
    }

    public IS getHd1_NamespaceID() {
        return this.getTyped(0, IS.class);
    }

    public ST getUniversalID() {
        return this.getTyped(1, ST.class);
    }

    public ST getHd2_UniversalID() {
        return this.getTyped(1, ST.class);
    }

    public ID getUniversalIDType() {
        return this.getTyped(2, ID.class);
    }

    public ID getHd3_UniversalIDType() {
        return this.getTyped(2, ID.class);
    }
}

