/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TQ;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXG
extends AbstractSegment {
    public RXG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Give Sub-ID Counter");
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(TQ.class, true, 1, 200, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Give Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(CM_LA1.class, false, 1, 200, new Object[]{this.getMessage()}, "Dispense-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Pharmacy Special Administration Instructions");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Rate Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Strength");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Strength Units");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Indication");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RXG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getGiveSubIDCounter() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getRxg1_GiveSubIDCounter() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxg2_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public TQ getQuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(3, 0);
        return retVal;
    }

    public TQ getRxg3_QuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getGiveCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRxg4_GiveCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRxg5_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxg6_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getGiveUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRxg7_GiveUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getGiveDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRxg8_GiveDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE[] getAdministrationNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getRxg9_AdministrationNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getAdministrationNotesReps() {
        return this.getReps(9);
    }

    public CE getAdministrationNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getRxg9_AdministrationNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxg9_AdministrationNotesReps() {
        return this.getReps(9);
    }

    public CE insertAdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertRxg9_AdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeAdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeRxg9_AdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getRxg10_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_LA1 getDispenseToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_LA1 getRxg11_DispenseToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getRxg12_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getPharmacySpecialAdministrationInstructions() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getRxg13_PharmacySpecialAdministrationInstructions() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getRxg14_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getRxg15_GiveRateAmount() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getRxg16_GiveRateUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getGiveStrength() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRxg17_GiveStrength() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getGiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getRxg18_GiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(19, new ST[0]);
        return retVal;
    }

    public ST[] getRxg19_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(19, new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(19);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(19, rep);
        return retVal;
    }

    public ST getRxg19_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxg19_SubstanceLotNumberReps() {
        return this.getReps(19);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST insertRxg19_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public ST removeRxg19_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public TS[] getSubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(20, new TS[0]);
        return retVal;
    }

    public TS[] getRxg20_SubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(20, new TS[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(20);
    }

    public TS getSubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(20, rep);
        return retVal;
    }

    public TS getRxg20_SubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(20, rep);
        return retVal;
    }

    public int getRxg20_SubstanceExpirationDateReps() {
        return this.getReps(20);
    }

    public TS insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(20, rep);
    }

    public TS insertRxg20_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(20, rep);
    }

    public TS removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(20, rep);
    }

    public TS removeRxg20_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(20, rep);
    }

    public CE[] getSubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(21, new CE[0]);
        return retVal;
    }

    public CE[] getRxg21_SubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(21, new CE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(21);
    }

    public CE getSubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(21, rep);
        return retVal;
    }

    public CE getRxg21_SubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getRxg21_SubstanceManufacturerNameReps() {
        return this.getReps(21);
    }

    public CE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE insertRxg21_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public CE removeRxg21_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public CE getIndication() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getRxg22_Indication() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new TQ(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 10: {
                return new CM_LA1(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new TS(this.getMessage());
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

