/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.CM;
import ca.uhn.hl7v2.model.v21.datatype.CQ;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.model.v21.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RX1
extends AbstractSegment {
    public RX1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UNUSED");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UNUSED Number 2");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "ROUTE");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "SITE ADMINISTERED");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage()}, "IV SOLUTION RATE");
            this.add(CQ.class, false, 1, 14, new Object[]{this.getMessage()}, "DRUG STRENGTH");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "FINAL CONCENTRATION");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "FINAL VOLUME IN ML.");
            this.add(CM.class, false, 1, 10, new Object[]{this.getMessage()}, "DRUG DOSE");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "DRUG ROLE");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "PRESCRIPTION SEQUENCE #");
            this.add(CQ.class, false, 1, 4, new Object[]{this.getMessage()}, "QUANTITY DISPENSED");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UNUSED Number 3");
            this.add(CE.class, false, 1, 5, new Object[]{this.getMessage()}, "DRUG ID");
            this.add(ID.class, false, 5, 5, new Object[]{this.getMessage(), new Integer(0)}, "COMPONENT DRUG IDS");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "PRESCRIPTION TYPE");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "SUBSTITUTION STATUS");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(38)}, "RX ORDER STATUS");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "NUMBER OF REFILLS");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UNUSED Number 4");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "REFILLS REMAINING");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "DEA CLASS");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "ORDERING MD'S DEA NUMBER");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "UNUSED Number 5");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "LAST REFILL DATE/TIME");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "RX NUMBER");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "PRN STATUS");
            this.add(TX.class, false, 5, 80, new Object[]{this.getMessage()}, "PHARMACY INSTRUCTIONS");
            this.add(TX.class, false, 5, 80, new Object[]{this.getMessage()}, "PATIENT INSTRUCTIONS");
            this.add(TX.class, false, 0, 500, new Object[]{this.getMessage()}, "INSTRUCTIONS (SIG)");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RX1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getUNUSED() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getRx11_UNUSED() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getUNUSEDNumber2() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getRx12_UNUSEDNumber2() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getROUTE() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getRx13_ROUTE() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSITEADMINISTERED() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getRx14_SITEADMINISTERED() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public CQ getIVSOLUTIONRATE() {
        CQ retVal = (CQ)this.getTypedField(5, 0);
        return retVal;
    }

    public CQ getRx15_IVSOLUTIONRATE() {
        CQ retVal = (CQ)this.getTypedField(5, 0);
        return retVal;
    }

    public CQ getDRUGSTRENGTH() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getRx16_DRUGSTRENGTH() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getFINALCONCENTRATION() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getRx17_FINALCONCENTRATION() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getFINALVOLUMEINML() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getRx18_FINALVOLUMEINML() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CM getDRUGDOSE() {
        CM retVal = (CM)this.getTypedField(9, 0);
        return retVal;
    }

    public CM getRx19_DRUGDOSE() {
        CM retVal = (CM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getDRUGROLE() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getRx110_DRUGROLE() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPRESCRIPTIONSEQUENCE() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getRx111_PRESCRIPTIONSEQUENCE() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getQUANTITYDISPENSED() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getRx112_QUANTITYDISPENSED() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getUNUSEDNumber3() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getRx113_UNUSEDNumber3() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getDRUGID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getRx114_DRUGID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public ID[] getCOMPONENTDRUGIDS() {
        ID[] retVal = (ID[])this.getTypedField(15, new ID[0]);
        return retVal;
    }

    public ID[] getRx115_COMPONENTDRUGIDS() {
        ID[] retVal = (ID[])this.getTypedField(15, new ID[0]);
        return retVal;
    }

    public int getCOMPONENTDRUGIDSReps() {
        return this.getReps(15);
    }

    public ID getCOMPONENTDRUGIDS(int rep) {
        ID retVal = (ID)this.getTypedField(15, rep);
        return retVal;
    }

    public ID getRx115_COMPONENTDRUGIDS(int rep) {
        ID retVal = (ID)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRx115_COMPONENTDRUGIDSReps() {
        return this.getReps(15);
    }

    public ID insertCOMPONENTDRUGIDS(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(15, rep);
    }

    public ID insertRx115_COMPONENTDRUGIDS(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(15, rep);
    }

    public ID removeCOMPONENTDRUGIDS(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(15, rep);
    }

    public ID removeRx115_COMPONENTDRUGIDS(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(15, rep);
    }

    public ID getPRESCRIPTIONTYPE() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getRx116_PRESCRIPTIONTYPE() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getSUBSTITUTIONSTATUS() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getRx117_SUBSTITUTIONSTATUS() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getRXORDERSTATUS() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getRx118_RXORDERSTATUS() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getNUMBEROFREFILLS() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getRx119_NUMBEROFREFILLS() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getUNUSEDNumber4() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getRx120_UNUSEDNumber4() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getREFILLSREMAINING() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getRx121_REFILLSREMAINING() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getDEACLASS() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getRx122_DEACLASS() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getORDERINGMDSDEANUMBER() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getRx123_ORDERINGMDSDEANUMBER() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getUNUSEDNumber5() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getRx124_UNUSEDNumber5() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public TS getLASTREFILLDATETIME() {
        TS retVal = (TS)this.getTypedField(25, 0);
        return retVal;
    }

    public TS getRx125_LASTREFILLDATETIME() {
        TS retVal = (TS)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getRXNUMBER() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ST getRx126_RXNUMBER() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getPRNSTATUS() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getRx127_PRNSTATUS() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public TX[] getPHARMACYINSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(28, new TX[0]);
        return retVal;
    }

    public TX[] getRx128_PHARMACYINSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(28, new TX[0]);
        return retVal;
    }

    public int getPHARMACYINSTRUCTIONSReps() {
        return this.getReps(28);
    }

    public TX getPHARMACYINSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(28, rep);
        return retVal;
    }

    public TX getRx128_PHARMACYINSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(28, rep);
        return retVal;
    }

    public int getRx128_PHARMACYINSTRUCTIONSReps() {
        return this.getReps(28);
    }

    public TX insertPHARMACYINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(28, rep);
    }

    public TX insertRx128_PHARMACYINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(28, rep);
    }

    public TX removePHARMACYINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(28, rep);
    }

    public TX removeRx128_PHARMACYINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(28, rep);
    }

    public TX[] getPATIENTINSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(29, new TX[0]);
        return retVal;
    }

    public TX[] getRx129_PATIENTINSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(29, new TX[0]);
        return retVal;
    }

    public int getPATIENTINSTRUCTIONSReps() {
        return this.getReps(29);
    }

    public TX getPATIENTINSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(29, rep);
        return retVal;
    }

    public TX getRx129_PATIENTINSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(29, rep);
        return retVal;
    }

    public int getRx129_PATIENTINSTRUCTIONSReps() {
        return this.getReps(29);
    }

    public TX insertPATIENTINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(29, rep);
    }

    public TX insertRx129_PATIENTINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(29, rep);
    }

    public TX removePATIENTINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(29, rep);
    }

    public TX removeRx129_PATIENTINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(29, rep);
    }

    public TX[] getINSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(30, new TX[0]);
        return retVal;
    }

    public TX[] getRx130_INSTRUCTIONS() {
        TX[] retVal = (TX[])this.getTypedField(30, new TX[0]);
        return retVal;
    }

    public int getINSTRUCTIONSReps() {
        return this.getReps(30);
    }

    public TX getINSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(30, rep);
        return retVal;
    }

    public TX getRx130_INSTRUCTIONS(int rep) {
        TX retVal = (TX)this.getTypedField(30, rep);
        return retVal;
    }

    public int getRx130_INSTRUCTIONSReps() {
        return this.getReps(30);
    }

    public TX insertINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(30, rep);
    }

    public TX insertRx130_INSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(30, rep);
    }

    public TX removeINSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(30, rep);
    }

    public TX removeRx130_INSTRUCTIONS(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(30, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new CQ(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(38));
            }
            case 18: {
                return new NM(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new NM(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new ST(this.getMessage());
            }
            case 24: {
                return new TS(this.getMessage());
            }
            case 25: {
                return new ST(this.getMessage());
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 27: {
                return new TX(this.getMessage());
            }
            case 28: {
                return new TX(this.getMessage());
            }
            case 29: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

