/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.registry;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.javascript.xmlimpl.XML;

public class ResourceHostObject
extends ScriptableObject {
    protected Resource resource;
    protected Context context;

    protected ResourceHostObject(Resource resource, Context cx) {
        this.resource = resource;
        this.context = cx;
    }

    public ResourceHostObject() {
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws CarbonException {
        if (args.length == 1) {
            if (args[0] instanceof Resource && !(args[0] instanceof Scriptable)) {
                return new ResourceHostObject((Resource)args[0], cx);
            }
            if (args[0] instanceof Scriptable) {
                throw new CarbonException("Resource object cannot be initialized directly, use registry.newResource() instead");
            }
            throw new CarbonException("Invalid argument type for Resource constructor");
        }
        throw new CarbonException("Resource object cannot be initialized directly, use registry.newResource() instead");
    }

    public String getClassName() {
        return "Resource";
    }

    public static void jsFunction_addProperty(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 2) {
            if (!(arguments[0] instanceof String) || !(arguments[1] instanceof String)) {
                throw new CarbonException("Invalid argument types for addProperty() method");
            }
        } else {
            throw new CarbonException("Invalid no. of arguments for addProperty() method");
        }
        resourceHostObject.resource.addProperty((String)arguments[0], (String)arguments[1]);
    }

    public static String jsFunction_getProperty(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                return resourceHostObject.resource.getProperty((String)arguments[0]);
            }
            throw new CarbonException("Invalid argument type for getProperty() method");
        }
        throw new CarbonException("Invalid no. of arguments for getProperty() method");
    }

    public static NativeArray jsFunction_getPropertyValues(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                return new NativeArray(resourceHostObject.resource.getPropertyValues((String)arguments[0]).toArray());
            }
            throw new CarbonException("Invalid argument type for getProperty() method");
        }
        throw new CarbonException("Invalid no. of arguments for getProperty() method");
    }

    public static NativeArray jsFunction_getProperties(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 0) {
            ArrayList<NativeObject> props = new ArrayList<NativeObject>();
            Properties properties = resourceHostObject.resource.getProperties();
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                NativeObject property = new NativeObject();
                String key = (String)propertyNames.nextElement();
                property.put("name", (Scriptable)property, (Object)key);
                property.put("value", (Scriptable)property, properties.get(key));
                props.add(property);
            }
            return new NativeArray(props.toArray());
        }
        throw new CarbonException("getProperties() method doesn't accept arguments");
    }

    public static void jsFunction_editPropertyValue(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 3) {
            if (!(arguments[0] instanceof String && arguments[1] instanceof String && arguments[2] instanceof String)) {
                throw new CarbonException("Invalid argument types for editProperty() method");
            }
        } else {
            throw new CarbonException("Invalid no. of arguments for editProperty() method");
        }
        resourceHostObject.resource.editPropertyValue((String)arguments[0], (String)arguments[1], (String)arguments[2]);
    }

    public static void jsFunction_removeProperty(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 1) {
            if (!(arguments[0] instanceof String)) {
                throw new CarbonException("Invalid argument type for removeProperty() method");
            }
        } else {
            throw new CarbonException("Invalid no. of arguments for removeProperty() method");
        }
        resourceHostObject.resource.removeProperty((String)arguments[0]);
    }

    public static void jsFunction_removePropertyValue(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length == 2) {
            if (!(arguments[0] instanceof String) || !(arguments[1] instanceof String)) {
                throw new CarbonException("Invalid argument types for removePropertyValue() method");
            }
        } else {
            throw new CarbonException("Invalid no. of arguments for removePropertyValue() method");
        }
        resourceHostObject.resource.removePropertyValue((String)arguments[0], (String)arguments[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_setProperty(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        ResourceHostObject resourceHostObject = (ResourceHostObject)thisObj;
        if (arguments.length != 2) throw new CarbonException("Invalid no. of arguments for setProperty() method");
        if (arguments[0] instanceof String && arguments[1] instanceof String) {
            resourceHostObject.resource.setProperty((String)arguments[0], (String)arguments[1]);
            return;
        } else {
            if (!(arguments[0] instanceof String) || !(arguments[1] instanceof NativeArray)) throw new CarbonException("Invalid argument types for setProperty() method");
            resourceHostObject.resource.setProperty((String)arguments[0], (List)Context.jsToJava((Object)arguments[1], List.class));
        }
    }

    public String jsGet_author() {
        return this.resource.getAuthorUserName();
    }

    public String jsGet_lastUpdatedUser() {
        return this.resource.getLastUpdaterUserName();
    }

    public Scriptable jsGet_createdTime() {
        return Context.toObject((Object)this.resource.getCreatedTime(), (Scriptable)this);
    }

    public Scriptable jsGet_lastUpdatedTime() {
        return Context.toObject((Object)this.resource.getLastModified(), (Scriptable)this);
    }

    public String jsGet_id() {
        return this.resource.getId();
    }

    public String jsGet_parentPath() {
        return this.resource.getParentPath();
    }

    public String jsGet_path() {
        return this.resource.getPath();
    }

    public String jsGet_permanentPath() {
        return this.resource.getPermanentPath();
    }

    public int jsGet_state() {
        return this.resource.getState();
    }

    public String jsGet_mediaType() {
        return this.resource.getMediaType();
    }

    public void jsSet_mediaType(Object mediaType) throws CarbonException {
        if (!(mediaType instanceof String)) {
            throw new CarbonException("Invalid property type for mediaType");
        }
        this.resource.setMediaType((String)mediaType);
    }

    public Object jsGet_content() throws CarbonException {
        try {
            Object result = this.resource.getContent();
            String mediaType = this.resource.getMediaType();
            if (result instanceof byte[]) {
                if (mediaType.matches(".*[\\/].*[xX][mM][lL].*")) {
                    return this.context.newObject((Scriptable)this, "XML", new Object[]{new String((byte[])result)});
                }
                return new String((byte[])result);
            }
            if (result instanceof String[]) {
                return new NativeArray((Object[])((String[])result));
            }
            return Context.toObject((Object)result, (Scriptable)this);
        }
        catch (RegistryException e) {
            throw new CarbonException("Registry Exception while reading content property", (Throwable)e);
        }
    }

    public void jsSet_content(Object content) throws CarbonException {
        if (content instanceof String) {
            try {
                this.resource.setContent((Object)((String)content));
            }
            catch (RegistryException e) {
                throw new CarbonException("Registry Exception while setting content property", (Throwable)e);
            }
        } else if (content instanceof XML) {
            try {
                this.resource.setContent((Object)((XML)content).getAxiomFromXML());
            }
            catch (RegistryException e) {
                throw new CarbonException("Registry Exception while setting content property", (Throwable)e);
            }
        } else {
            throw new CarbonException("Invalid property type for content");
        }
    }

    public String jsGet_description() {
        return this.resource.getDescription();
    }

    public void jsSet_description(Object description) throws CarbonException {
        if (!(description instanceof String)) {
            throw new CarbonException("Invalid property type for description");
        }
        this.resource.setDescription((String)description);
    }

    protected Resource getResource() {
        return this.resource;
    }
}

