/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp;

import java.util.HashMap;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.VirtualFirealarmXMPPException;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppAccount;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppConfig;

public class XmppServerClient {
    public static boolean createAccount(XmppAccount xmppAccount) throws VirtualFirealarmXMPPException {
        if (XmppConfig.getInstance().isEnabled()) {
            if (xmppAccount != null) {
                try {
                    ConnectionConfiguration config = new ConnectionConfiguration(XmppConfig.getInstance().getHost(), XmppConfig.getInstance().getPort(), "Accounts");
                    XMPPConnection xmppConnection = new XMPPConnection(config);
                    xmppConnection.connect();
                    xmppConnection.login(XmppConfig.getInstance().getUsername(), XmppConfig.getInstance().getPassword());
                    AccountManager accountManager = xmppConnection.getAccountManager();
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("username", xmppAccount.getUsername());
                    attributes.put("password", xmppAccount.getPassword());
                    attributes.put("email", xmppAccount.getEmail());
                    attributes.put("name", xmppAccount.getAccountName());
                    accountManager.createAccount(xmppAccount.getUsername(), xmppAccount.getPassword(), attributes);
                    xmppConnection.disconnect();
                    return true;
                }
                catch (XMPPException e) {
                    if (e.getXMPPError().getCode() == 409) {
                        return true;
                    }
                    throw new VirtualFirealarmXMPPException("XMPP account creation failed. Error: " + e.getLocalizedMessage(), (Exception)((Object)e));
                }
            }
            throw new VirtualFirealarmXMPPException("Invalid XMPP attributes");
        }
        return true;
    }
}

