/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.axis2.util.Utils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.device.mgt.common.DeviceManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationEntry;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.PlatformConfiguration;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.APIUtil;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipArchive;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipUtil;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppConfig;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    private static final Log log = LogFactory.getLog(ZipUtil.class);
    private static final String LOCALHOST = "localhost";
    private static final String HTTPS_PROTOCOL_URL = "https://${iot.gateway.host}:${iot.gateway.https.port}";
    private static final String HTTP_PROTOCOL_URL = "http://${iot.gateway.host}:${iot.gateway.http.port}";
    private static final String CONFIG_TYPE = "general";
    private static final String DEFAULT_MQTT_ENDPOINT = "tcp://${mqtt.broker.host}:${mqtt.broker.port}";

    public ZipArchive createZipFile(String owner, String deviceType, String deviceId, String deviceName, String apiApplicationKey, String token, String refreshToken) throws DeviceManagementException {
        String sketchFolder = "repository" + File.separator + "resources" + File.separator + "sketches";
        String templateSketchPath = sketchFolder + File.separator + deviceType;
        try {
            PlatformConfiguration configuration;
            String iotServerIP = ZipUtil.getServerUrl();
            String httpsServerEP = org.wso2.carbon.core.util.Utils.replaceSystemProperty((String)"https://${iot.gateway.host}:${iot.gateway.https.port}");
            String httpServerEP = org.wso2.carbon.core.util.Utils.replaceSystemProperty((String)"http://${iot.gateway.host}:${iot.gateway.http.port}");
            String mqttEndpoint = org.wso2.carbon.core.util.Utils.replaceSystemProperty((String)"tcp://${mqtt.broker.host}:${mqtt.broker.port}");
            if (mqttEndpoint.contains("localhost")) {
                mqttEndpoint = mqttEndpoint.replace("localhost", iotServerIP);
                httpsServerEP = httpsServerEP.replace("localhost", iotServerIP);
                httpServerEP = httpServerEP.replace("localhost", iotServerIP);
            }
            String xmppEndpoint = "";
            if (XmppConfig.getInstance().isEnabled() && (xmppEndpoint = XmppConfig.getInstance().getHost() + ":" + XmppConfig.getInstance().getPort()).contains("localhost")) {
                xmppEndpoint = xmppEndpoint.replace("localhost", iotServerIP);
            }
            if ((configuration = APIUtil.getTenantConfigurationManagementService().getConfiguration("general")) != null && configuration.getConfiguration() != null && configuration.getConfiguration().size() > 0) {
                List configurations = configuration.getConfiguration();
                for (ConfigurationEntry configurationEntry : configurations) {
                    switch (configurationEntry.getName()) {
                        case "VIRTUAL_FIREALARM_HTTPS_EP": {
                            httpsServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_HTTP_EP": {
                            httpServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_MQTT_EP": {
                            mqttEndpoint = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_XMPP_EP": {
                            xmppEndpoint = (String)configurationEntry.getValue();
                        }
                    }
                }
            }
            String base64EncodedApplicationKey = this.getBase64EncodedAPIAppKey(apiApplicationKey).trim();
            HashMap<String, String> contextParams = new HashMap<String, String>();
            contextParams.put("TENANT_DOMAIN", APIUtil.getTenantDomainOftheUser());
            contextParams.put("DEVICE_OWNER", owner);
            contextParams.put("DEVICE_ID", deviceId);
            contextParams.put("DEVICE_NAME", deviceName);
            contextParams.put("HTTPS_EP", httpsServerEP);
            contextParams.put("HTTP_EP", httpServerEP);
            contextParams.put("APIM_EP", httpServerEP);
            contextParams.put("MQTT_EP", mqttEndpoint);
            contextParams.put("XMPP_EP", "XMPP:" + xmppEndpoint);
            contextParams.put("API_APPLICATION_KEY", base64EncodedApplicationKey);
            contextParams.put("DEVICE_TOKEN", token);
            contextParams.put("DEVICE_REFRESH_TOKEN", refreshToken);
            contextParams.put("SERVER_NAME", XmppConfig.getInstance().getServerName() == null ? "" : XmppConfig.getInstance().getServerName());
            contextParams.put("SERVER_JID", XmppConfig.getInstance().getJid() == null ? "" : XmppConfig.getInstance().getJid());
            ZipArchive zipFile = this.getSketchArchive(templateSketchPath, contextParams, deviceName);
            return zipFile;
        }
        catch (IOException e) {
            throw new DeviceManagementException("Zip File Creation Failed", (Exception)e);
        }
        catch (ConfigurationManagementException e) {
            throw new DeviceManagementException("Failed to retrieve configuration", (Exception)((Object)e));
        }
    }

    private String getBase64EncodedAPIAppKey(String apiAppCredentialsAsJSONString) {
        JSONObject jsonObject = new JSONObject(apiAppCredentialsAsJSONString);
        String consumerKey = jsonObject.get("client_id").toString();
        String consumerSecret = jsonObject.get("client_secret").toString();
        String stringToEncode = consumerKey + ":" + consumerSecret;
        return Base64.encodeBase64String((byte[])stringToEncode.getBytes());
    }

    private static String getServerUrl() {
        try {
            return Utils.getIpAddress();
        }
        catch (SocketException e) {
            log.warn((Object)"Failed retrieving the hostname, therefore set to localhost", (Throwable)e);
            return "localhost";
        }
    }

    private ZipArchive getSketchArchive(String templateSketchPath, Map contextParams, String zipFileName) throws DeviceManagementException, IOException {
        String sketchPath = CarbonUtils.getCarbonHome() + File.separator + templateSketchPath;
        zipFileName = zipFileName + ".zip";
        try {
            Map properties = ZipUtil.getProperties((String)(sketchPath + File.separator + "sketch.properties"));
            List templateFiles = (List)properties.get("templates");
            ArrayList<TemplateFile> processTemplateFiles = new ArrayList<TemplateFile>();
            for (String templateFile : templateFiles) {
                TemplateFile tFile = new TemplateFile(this);
                tFile.setContent(ZipUtil.parseTemplate((String)(templateSketchPath + File.separator + templateFile), (Map)contextParams));
                tFile.setFileName(templateFile);
                processTemplateFiles.add(tFile);
            }
            templateFiles.add("sketch.properties");
            byte[] zip = ZipUtil.createZipArchive((String)templateSketchPath, processTemplateFiles);
            return new ZipArchive(zipFileName, zip);
        }
        catch (IOException ex) {
            throw new DeviceManagementException("Error occurred when trying to read property file sketch.properties", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> getProperties(String propertyFilePath) throws IOException {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propertyFilePath);
            prop.load(input);
            HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
            String templates = prop.getProperty("templates");
            1 list = new ArrayList(Arrays.asList(templates.split(",")));
            properties.put("templates", (List<String>)list);
            String filename = prop.getProperty("zipfilename");
            list = new /* Unavailable Anonymous Inner Class!! */;
            properties.put("zipfilename", (List<String>)list);
            HashMap<String, List<String>> hashMap = properties;
            return hashMap;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseTemplate(String srcFile, Map contextParams) throws IOException {
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(srcFile);
            String content = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.toString());
            for (Map.Entry mapEntry : contextParams.entrySet()) {
                content = content.replaceAll("\\$\\{" + mapEntry.getKey() + "\\}", mapEntry.getValue().toString());
            }
            String string = content;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createZipArchive(String srcFolder, List<TemplateFile> processTemplateFiles) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new BufferedOutputStream(baos));
            File subDir = new File(srcFolder);
            String[] subdirList = subDir.list();
            if (subdirList == null) {
                log.warn((Object)("The sub directory " + subDir.getAbsolutePath() + " is empty"));
                byte[] byArray = null;
                return byArray;
            }
            for (String sd : subdirList) {
                ZipEntry entry;
                File f = new File(srcFolder + File.separator + sd);
                if (f.isDirectory()) {
                    String[] files = f.list();
                    if (files == null) {
                        log.warn((Object)("The current directory " + f.getAbsolutePath() + " is empty. Has no files"));
                        byte[] byArray = null;
                        return byArray;
                    }
                    for (int i = 0; i < files.length; ++i) {
                        boolean fileAdded = false;
                        for (TemplateFile templateFile : processTemplateFiles) {
                            if (files[i].equals(templateFile.getFileName())) {
                                ZipEntry entry2 = new ZipEntry(templateFile.getFileName());
                                out.putNextEntry(entry2);
                                out.write(templateFile.getContent().getBytes());
                                out.closeEntry();
                                fileAdded = true;
                                break;
                            }
                            if (!f.getName().equals("sketch.properties")) continue;
                            fileAdded = true;
                            break;
                        }
                        if (fileAdded) continue;
                        entry = new ZipEntry(sd + File.separator + files[i]);
                        out.putNextEntry(entry);
                        out.write(IOUtils.toByteArray((InputStream)new FileInputStream(srcFolder + File.separator + sd + File.separator + files[i])));
                        out.closeEntry();
                    }
                    continue;
                }
                boolean fileAdded = false;
                for (TemplateFile templateFile : processTemplateFiles) {
                    if (f.getName().equals(templateFile.getFileName())) {
                        entry = new ZipEntry(templateFile.getFileName());
                        out.putNextEntry(entry);
                        out.write(templateFile.getContent().getBytes());
                        out.closeEntry();
                        fileAdded = true;
                        break;
                    }
                    if (!f.getName().equals("sketch.properties")) continue;
                    fileAdded = true;
                    break;
                }
                if (fileAdded) continue;
                ZipEntry entry3 = new ZipEntry(sd);
                out.putNextEntry(entry3);
                out.write(IOUtils.toByteArray((InputStream)new FileInputStream(f)));
                out.closeEntry();
            }
            out.finish();
        }
        return baos.toByteArray();
    }
}

