/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

/*
 * Exception performing whole class analysis ignored.
 */
public class VirtualFireAlarmPermissionUpdateListener
implements ServletContextListener {
    private static Log log = LogFactory.getLog(VirtualFireAlarmPermissionUpdateListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        UserStoreManager userStoreManager = VirtualFireAlarmPermissionUpdateListener.getUserStoreManager();
        try {
            if (userStoreManager != null) {
                if (!userStoreManager.isExistingRole("internal/devicemgt-user")) {
                    userStoreManager.addRole("internal/devicemgt-user", null, this.getPermissions());
                } else {
                    VirtualFireAlarmPermissionUpdateListener.getAuthorizationManager().authorizeRole("internal/devicemgt-user", "/permission/admin/device-mgt/devices/enroll/firealarm", "ui.execute");
                    VirtualFireAlarmPermissionUpdateListener.getAuthorizationManager().authorizeRole("internal/devicemgt-user", "/permission/admin/device-mgt/devices/owning-device/view", "ui.execute");
                }
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while creating a role and adding a user for Raspberry PI.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public static UserStoreManager getUserStoreManager() {
        UserStoreManager userStoreManager;
        try {
            PrivilegedCarbonContext ctx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            RealmService realmService = (RealmService)ctx.getOSGiService(RealmService.class, null);
            if (realmService == null) {
                String msg = "Realm service has not initialized.";
                log.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            int tenantId = ctx.getTenantId();
            userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            realmService.getTenantUserRealm(tenantId).getAuthorizationManager();
        }
        catch (UserStoreException e) {
            String msg = "Error occurred while retrieving current user store manager";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
        return userStoreManager;
    }

    public static AuthorizationManager getAuthorizationManager() {
        AuthorizationManager authorizationManager;
        try {
            PrivilegedCarbonContext ctx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            RealmService realmService = (RealmService)ctx.getOSGiService(RealmService.class, null);
            if (realmService == null) {
                String msg = "Realm service has not initialized.";
                log.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            int tenantId = ctx.getTenantId();
            authorizationManager = realmService.getTenantUserRealm(tenantId).getAuthorizationManager();
        }
        catch (UserStoreException e) {
            String msg = "Error occurred while retrieving current user store manager";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
        return authorizationManager;
    }

    private Permission[] getPermissions() {
        Permission androidSense = new Permission("/permission/admin/device-mgt/devices/enroll/firealarm", "ui.execute");
        Permission view = new Permission("/permission/admin/device-mgt/devices/owning-device/view", "ui.execute");
        return new Permission[]{androidSense, view};
    }
}

