/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.dataservice.commons.SortByField;
import org.wso2.carbon.analytics.dataservice.commons.SortType;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.apimgt.application.extension.APIManagementProviderService;
import org.wso2.carbon.apimgt.application.extension.dto.ApiApplicationKey;
import org.wso2.carbon.apimgt.application.extension.exception.APIManagerException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.common.Device;
import org.wso2.carbon.device.mgt.common.DeviceIdentifier;
import org.wso2.carbon.device.mgt.common.DeviceManagementException;
import org.wso2.carbon.device.mgt.common.EnrolmentInfo;
import org.wso2.carbon.device.mgt.common.InvalidDeviceException;
import org.wso2.carbon.device.mgt.common.authorization.DeviceAccessAuthorizationException;
import org.wso2.carbon.device.mgt.common.group.mgt.DeviceGroupConstants;
import org.wso2.carbon.device.mgt.common.operation.mgt.Operation;
import org.wso2.carbon.device.mgt.common.operation.mgt.OperationManagementException;
import org.wso2.carbon.device.mgt.core.operation.mgt.CommandOperation;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.VirtualFireAlarmService;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.APIUtil;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipArchive;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipUtil;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.VirtualFirealarmXMPPException;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppAccount;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppConfig;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp.XmppServerClient;
import org.wso2.carbon.identity.jwt.client.extension.JWTClient;
import org.wso2.carbon.identity.jwt.client.extension.dto.AccessTokenInfo;
import org.wso2.carbon.identity.jwt.client.extension.exception.JWTClientException;
import org.wso2.carbon.user.api.UserStoreException;

/*
 * Exception performing whole class analysis ignored.
 */
public class VirtualFireAlarmServiceImpl
implements VirtualFireAlarmService {
    private static final String KEY_TYPE = "PRODUCTION";
    private static ApiApplicationKey apiApplicationKey;
    private static Log log;

    @POST
    @Path(value="device/{deviceId}/buzz")
    public Response switchBuzzer(@PathParam(value="deviceId") String deviceId, @FormParam(value="state") String state) {
        if (state == null || state.isEmpty()) {
            log.error((Object)"State is not defined for the buzzer operation");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String switchToState = state.toUpperCase();
        if (!switchToState.equals("ON") && !switchToState.equals("OFF")) {
            log.error((Object)"The requested state change shoud be either - 'ON' or 'OFF'");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            if (!APIUtil.getDeviceAccessAuthorizationService().isUserAuthorized(new DeviceIdentifier(deviceId, "virtual_firealarm"), DeviceGroupConstants.Permissions.DEFAULT_OPERATOR_PERMISSIONS)) {
                return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).build();
            }
            String resource = "BULB".replace("/", "");
            String actualMessage = resource + ":" + switchToState;
            String publishTopic = APIUtil.getTenantDomainOftheUser() + "/" + "virtual_firealarm" + "/" + deviceId;
            CommandOperation commandOp = new CommandOperation();
            commandOp.setCode("buzz");
            commandOp.setType(Operation.Type.COMMAND);
            commandOp.setEnabled(true);
            commandOp.setPayLoad((Object)actualMessage);
            Properties props = new Properties();
            props.setProperty("mqtt.adapter.topic", publishTopic);
            props.setProperty("xmpp.client.jid", deviceId + "@" + XmppConfig.getInstance().getServerName());
            props.setProperty("xmpp.client.subject", "CONTROL-REQUEST");
            props.setProperty("xmpp.client.messageType", "chat");
            commandOp.setProperties(props);
            ArrayList<DeviceIdentifier> deviceIdentifiers = new ArrayList<DeviceIdentifier>();
            deviceIdentifiers.add(new DeviceIdentifier(deviceId, "virtual_firealarm"));
            APIUtil.getDeviceManagementService().addOperation("virtual_firealarm", (Operation)commandOp, deviceIdentifiers);
            return Response.ok().build();
        }
        catch (InvalidDeviceException e) {
            String msg = "Error occurred while executing command operation to send keywords";
            log.error((Object)msg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (DeviceAccessAuthorizationException e) {
            log.error((Object)e.getErrorMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (OperationManagementException e) {
            String msg = "Error occurred while executing command operation upon ringing the buzzer";
            log.error((Object)msg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="device/stats/{deviceId}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getVirtualFirealarmStats(@PathParam(value="deviceId") String deviceId, @QueryParam(value="from") long from, @QueryParam(value="to") long to) {
        String fromDate = String.valueOf(from * 1000L);
        String toDate = String.valueOf(to * 1000L);
        String query = "meta_deviceId:" + deviceId + " AND meta_deviceType:" + "virtual_firealarm" + " AND meta_time : [" + fromDate + " TO " + toDate + "]";
        String sensorTableName = "IOT_PER_DEVICE_STREAM_VIRTUALFIREALARM_TEMPERATURE";
        try {
            if (!APIUtil.getDeviceAccessAuthorizationService().isUserAuthorized(new DeviceIdentifier(deviceId, "virtual_firealarm"), DeviceGroupConstants.Permissions.DEFAULT_STATS_MONITOR_PERMISSIONS)) {
                return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).build();
            }
            ArrayList<SortByField> sortByFields = new ArrayList<SortByField>();
            SortByField sortByField = new SortByField("meta_time", SortType.ASC);
            sortByFields.add(sortByField);
            List sensorRecords = APIUtil.getAllEventsForDevice((String)sensorTableName, (String)query, sortByFields);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)sensorRecords).build();
        }
        catch (AnalyticsException e) {
            String errorMsg = "Error on retrieving stats on table " + sensorTableName + " with query " + query;
            log.error((Object)errorMsg);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)errorMsg).build();
        }
        catch (DeviceAccessAuthorizationException e) {
            log.error((Object)e.getErrorMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="device/download")
    @GET
    @Produces(value={"application/zip"})
    public Response downloadSketch(@QueryParam(value="deviceName") String deviceName, @QueryParam(value="sketchType") String sketchType) {
        try {
            String user = APIUtil.getAuthenticatedUser() + "@" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            ZipArchive zipFile = this.createDownloadFile(user, deviceName, sketchType);
            Response.ResponseBuilder response = Response.ok((Object)zipFile.getZipFileContent());
            response.status(Response.Status.OK);
            response.type("application/zip");
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + zipFile.getFileName() + "\""));
            Response resp = response.build();
            return resp;
        }
        catch (IllegalArgumentException ex) {
            return Response.status((int)400).entity((Object)ex.getMessage()).build();
        }
        catch (DeviceManagementException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
        catch (JWTClientException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
        catch (APIManagerException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
        catch (UserStoreException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
        catch (VirtualFirealarmXMPPException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
    }

    private boolean register(String deviceId, String name) {
        try {
            DeviceIdentifier deviceIdentifier = new DeviceIdentifier();
            deviceIdentifier.setId(deviceId);
            deviceIdentifier.setType("virtual_firealarm");
            if (APIUtil.getDeviceManagementService().isEnrolled(deviceIdentifier)) {
                return false;
            }
            Device device = new Device();
            device.setDeviceIdentifier(deviceId);
            EnrolmentInfo enrolmentInfo = new EnrolmentInfo();
            enrolmentInfo.setDateOfEnrolment(Long.valueOf(new Date().getTime()));
            enrolmentInfo.setDateOfLastUpdate(Long.valueOf(new Date().getTime()));
            enrolmentInfo.setStatus(EnrolmentInfo.Status.ACTIVE);
            enrolmentInfo.setOwnership(EnrolmentInfo.OwnerShip.BYOD);
            device.setName(name);
            device.setType("virtual_firealarm");
            enrolmentInfo.setOwner(APIUtil.getAuthenticatedUser());
            device.setEnrolmentInfo(enrolmentInfo);
            return APIUtil.getDeviceManagementService().enrollDevice(device);
        }
        catch (DeviceManagementException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private ZipArchive createDownloadFile(String owner, String deviceName, String sketchType) throws DeviceManagementException, APIManagerException, JWTClientException, UserStoreException, VirtualFirealarmXMPPException {
        String deviceId = VirtualFireAlarmServiceImpl.shortUUID();
        boolean status = this.register(deviceId, deviceName);
        if (!status) {
            String msg = "Error occurred while registering the device with id: " + deviceId + " owner:" + owner;
            throw new DeviceManagementException(msg);
        }
        if (apiApplicationKey == null) {
            String applicationUsername = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getAdminUserName() + "@" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            APIManagementProviderService apiManagementProviderService = APIUtil.getAPIManagementProviderService();
            String[] tags = new String[]{"virtual_firealarm"};
            apiApplicationKey = apiManagementProviderService.generateAndRetrieveApplicationKeys("virtual_firealarm", tags, "PRODUCTION", applicationUsername, true, "3600");
        }
        JWTClient jwtClient = APIUtil.getJWTClientManagerService().getJWTClient();
        String scopes = " device_" + deviceId;
        AccessTokenInfo accessTokenInfo = jwtClient.getAccessToken(apiApplicationKey.getConsumerKey(), apiApplicationKey.getConsumerSecret(), owner, scopes);
        String accessToken = accessTokenInfo.getAccessToken();
        String refreshToken = accessTokenInfo.getRefreshToken();
        XmppAccount newXmppAccount = new XmppAccount();
        newXmppAccount.setAccountName(deviceId);
        newXmppAccount.setUsername(deviceId);
        newXmppAccount.setPassword(accessToken);
        newXmppAccount.setEmail(deviceId + "@" + APIUtil.getTenantDomainOftheUser());
        status = XmppServerClient.createAccount((XmppAccount)newXmppAccount);
        if (!status) {
            String msg = "XMPP Account was not created for device - " + deviceId + " of owner - " + owner + ".XMPP might have been disabled in org.wso2.carbon.device.mgt.iot" + ".common.config.server.configs";
            throw new DeviceManagementException(msg);
        }
        ZipUtil ziputil = new ZipUtil();
        return ziputil.createZipFile(owner, sketchType, deviceId, deviceName, apiApplicationKey.toString(), accessToken, refreshToken);
    }

    private static String shortUUID() {
        UUID uuid = UUID.randomUUID();
        long l = ByteBuffer.wrap(uuid.toString().getBytes(StandardCharsets.UTF_8)).getLong();
        return Long.toString(l, 36);
    }

    static {
        log = LogFactory.getLog(VirtualFireAlarmServiceImpl.class);
    }
}

