/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.device.mgt.common.DeviceManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationEntry;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.PlatformConfiguration;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.plugin.xmpp.XmppConfig;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.APIUtil;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipArchive;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.ZipUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    private static final Log log = LogFactory.getLog(ZipUtil.class);
    private static final String HTTPS_PORT_PROPERTY = "httpsPort";
    private static final String HTTP_PORT_PROPERTY = "httpPort";
    private static final String LOCALHOST = "localhost";
    private static final String HTTPS_PROTOCOL_APPENDER = "https://";
    private static final String HTTP_PROTOCOL_APPENDER = "http://";
    private static final String CONFIG_TYPE = "general";
    private static final String DEFAULT_MQTT_ENDPOINT = "tcp://localhost:1886";
    public static final String HOST_NAME = "HostName";

    public ZipArchive createZipFile(String owner, String deviceType, String deviceId, String deviceName, String apiApplicationKey, String token, String refreshToken) throws DeviceManagementException {
        String sketchFolder = "repository" + File.separator + "resources" + File.separator + "sketches";
        String archivesPath = CarbonUtils.getCarbonHome() + File.separator + sketchFolder + File.separator + "archives" + File.separator + deviceId;
        String templateSketchPath = sketchFolder + File.separator + deviceType;
        try {
            PlatformConfiguration configuration;
            String iotServerIP = ZipUtil.getServerUrl();
            String httpsServerPort = System.getProperty("httpsPort");
            String httpServerPort = System.getProperty("httpPort");
            String httpsServerEP = "https://" + iotServerIP + ":" + httpsServerPort;
            String httpServerEP = "http://" + iotServerIP + ":" + httpServerPort;
            String mqttEndpoint = "tcp://localhost:1886";
            if (mqttEndpoint.contains("localhost")) {
                mqttEndpoint = mqttEndpoint.replace("localhost", iotServerIP);
            }
            String xmppEndpoint = "";
            if (XmppConfig.getInstance().isEnabled() && (xmppEndpoint = XmppConfig.getInstance().getHost() + ":" + XmppConfig.getInstance().getPort()).contains("localhost")) {
                xmppEndpoint = xmppEndpoint.replace("localhost", iotServerIP);
            }
            if ((configuration = APIUtil.getTenantConfigurationManagementService().getConfiguration("general")) != null && configuration.getConfiguration() != null && configuration.getConfiguration().size() > 0) {
                List configurations = configuration.getConfiguration();
                for (ConfigurationEntry configurationEntry : configurations) {
                    switch (configurationEntry.getName()) {
                        case "VIRTUAL_FIREALARM_HTTPS_EP": {
                            httpsServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_HTTP_EP": {
                            httpServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_MQTT_EP": {
                            mqttEndpoint = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_XMPP_EP": {
                            xmppEndpoint = (String)configurationEntry.getValue();
                        }
                    }
                }
            }
            String base64EncodedApplicationKey = this.getBase64EncodedAPIAppKey(apiApplicationKey).trim();
            HashMap<String, String> contextParams = new HashMap<String, String>();
            contextParams.put("TENANT_DOMAIN", APIUtil.getTenantDomainOftheUser());
            contextParams.put("DEVICE_OWNER", owner);
            contextParams.put("DEVICE_ID", deviceId);
            contextParams.put("DEVICE_NAME", deviceName);
            contextParams.put("HTTPS_EP", httpsServerEP);
            contextParams.put("HTTP_EP", httpServerEP);
            contextParams.put("APIM_EP", httpServerEP);
            contextParams.put("MQTT_EP", mqttEndpoint);
            contextParams.put("XMPP_EP", "XMPP:" + xmppEndpoint);
            contextParams.put("API_APPLICATION_KEY", base64EncodedApplicationKey);
            contextParams.put("DEVICE_TOKEN", token);
            contextParams.put("DEVICE_REFRESH_TOKEN", refreshToken);
            contextParams.put("SERVER_NAME", XmppConfig.getInstance().getServerName() == null ? "" : XmppConfig.getInstance().getServerName());
            contextParams.put("SERVER_JID", XmppConfig.getInstance().getJid() == null ? "" : XmppConfig.getInstance().getJid());
            ZipArchive zipFile = ZipUtil.getSketchArchive((String)archivesPath, (String)templateSketchPath, contextParams, (String)deviceName);
            return zipFile;
        }
        catch (IOException e) {
            throw new DeviceManagementException("Zip File Creation Failed", (Exception)e);
        }
        catch (ConfigurationManagementException e) {
            throw new DeviceManagementException("Failed to retrieve configuration", (Exception)((Object)e));
        }
    }

    private String getBase64EncodedAPIAppKey(String apiAppCredentialsAsJSONString) {
        JSONObject jsonObject = new JSONObject(apiAppCredentialsAsJSONString);
        String consumerKey = jsonObject.get("client_id").toString();
        String consumerSecret = jsonObject.get("client_secret").toString();
        String stringToEncode = consumerKey + ":" + consumerSecret;
        return Base64.encodeBase64String((byte[])stringToEncode.getBytes());
    }

    public static String getServerUrl() {
        String hostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
        try {
            if (hostName == null) {
                hostName = NetworkUtils.getLocalHostname();
            }
        }
        catch (SocketException e) {
            hostName = "localhost";
            log.warn((Object)"Failed retrieving the hostname, therefore set to localhost", (Throwable)e);
        }
        return hostName;
    }

    public static ZipArchive getSketchArchive(String archivesPath, String templateSketchPath, Map contextParams, String zipFileName) throws DeviceManagementException, IOException {
        String sketchPath = CarbonUtils.getCarbonHome() + File.separator + templateSketchPath;
        FileUtils.deleteDirectory((File)new File(archivesPath));
        FileUtils.deleteDirectory((File)new File(archivesPath + ".zip"));
        if (!new File(archivesPath).mkdirs()) {
            String message = "Could not create directory at path: " + archivesPath;
            log.error((Object)message);
            throw new DeviceManagementException(message);
        }
        zipFileName = zipFileName + ".zip";
        try {
            Map properties = ZipUtil.getProperties((String)(sketchPath + File.separator + "sketch" + ".properties"));
            List templateFiles = (List)properties.get("templates");
            for (String templateFile : templateFiles) {
                ZipUtil.parseTemplate((String)(templateSketchPath + File.separator + templateFile), (String)(archivesPath + File.separator + templateFile), (Map)contextParams);
            }
            templateFiles.add("sketch.properties");
            ZipUtil.copyFolder((File)new File(sketchPath), (File)new File(archivesPath), (List)templateFiles);
            ZipUtil.createZipArchive((String)archivesPath);
            FileUtils.deleteDirectory((File)new File(archivesPath));
            File zip = new File(archivesPath + ".zip");
            return new ZipArchive(zipFileName, zip);
        }
        catch (IOException ex) {
            throw new DeviceManagementException("Error occurred when trying to read property file sketch.properties", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> getProperties(String propertyFilePath) throws IOException {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propertyFilePath);
            prop.load(input);
            HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
            String templates = prop.getProperty("templates");
            1 list = new ArrayList(Arrays.asList(templates.split(",")));
            properties.put("templates", (List<String>)list);
            String filename = prop.getProperty("zipfilename");
            list = new /* Unavailable Anonymous Inner Class!! */;
            properties.put("zipfilename", (List<String>)list);
            HashMap<String, List<String>> hashMap = properties;
            return hashMap;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseTemplate(String srcFile, String dstFile, Map contextParams) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(dstFile);
            String content = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.toString());
            for (Map.Entry mapEntry : contextParams.entrySet()) {
                content = content.replaceAll("\\$\\{" + mapEntry.getKey() + "\\}", mapEntry.getValue().toString());
            }
            IOUtils.write((String)content, (OutputStream)outputStream, (String)StandardCharsets.UTF_8.toString());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFolder(File src, File dest, List<String> excludeFileNames) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                String message = "Could not create directory at path: " + dest;
                log.error((Object)message);
                throw new IOException(message);
            }
            String[] files = src.list();
            if (files == null) {
                log.warn((Object)("There are no files insides the directory " + src.getAbsolutePath()));
                return;
            }
            for (String file : files) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                ZipUtil.copyFolder((File)srcFile, (File)destFile, excludeFileNames);
            }
        } else {
            for (String fileName : excludeFileNames) {
                if (!src.getName().equals(fileName)) continue;
                return;
            }
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int length;
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createZipArchive(String srcFolder) throws IOException {
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        try {
            int BUFFER = 2048;
            FileOutputStream dest = new FileOutputStream(new File(srcFolder + ".zip"));
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File subDir = new File(srcFolder);
            String[] subdirList = subDir.list();
            if (subdirList == null) {
                log.warn((Object)("The sub directory " + subDir.getAbsolutePath() + " is empty"));
                boolean bl = false;
                return bl;
            }
            for (String sd : subdirList) {
                int count;
                File f = new File(srcFolder + "/" + sd);
                if (f.isDirectory()) {
                    String[] files = f.list();
                    if (files == null) {
                        log.warn((Object)("The current directory " + f.getAbsolutePath() + " is empty. Has no files"));
                        boolean bl = false;
                        return bl;
                    }
                    for (int i = 0; i < files.length; ++i) {
                        int count2;
                        FileInputStream fi = new FileInputStream(srcFolder + "/" + sd + "/" + files[i]);
                        origin = new BufferedInputStream(fi, 2048);
                        ZipEntry entry = new ZipEntry(sd + "/" + files[i]);
                        out.putNextEntry(entry);
                        while ((count2 = origin.read(data, 0, 2048)) != -1) {
                            out.write(data, 0, count2);
                            out.flush();
                        }
                    }
                    continue;
                }
                FileInputStream fi = new FileInputStream(f);
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(sd);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                    out.flush();
                }
            }
            out.flush();
        }
        finally {
            if (origin != null) {
                origin.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return true;
    }
}

