/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmppConfig {
    private String host;
    private int port;
    private String username;
    private String password;
    private String serverName;
    private boolean enabled;
    private String jid;
    private static XmppConfig xmppConfig = new XmppConfig();
    private static final Log log = LogFactory.getLog(XmppConfig.class);
    private static final String ENABLED = "enabled";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SERVERNAME = "serverName";
    private static final String JID = "jid";

    private XmppConfig() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream("../xmpp.properties");
        Properties properties = new Properties();
        try {
            properties.load(input);
            this.enabled = Boolean.parseBoolean(properties.getProperty(ENABLED, "false"));
            this.host = properties.getProperty(HOST);
            this.port = Integer.parseInt(properties.getProperty(PORT));
            this.username = properties.getProperty(USERNAME);
            this.password = properties.getProperty(PASSWORD);
            this.serverName = properties.getProperty(SERVERNAME);
            this.jid = properties.getProperty(JID);
        }
        catch (IOException e) {
            log.error((Object)"Failed to load xmpp config properties.");
        }
    }

    public static XmppConfig getInstance() {
        return xmppConfig;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }
}

