/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.device.mgt.common.DeviceManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationEntry;
import org.wso2.carbon.device.mgt.common.configuration.mgt.ConfigurationManagementException;
import org.wso2.carbon.device.mgt.common.configuration.mgt.PlatformConfiguration;
import org.wso2.carbon.device.mgt.iot.util.Utils;
import org.wso2.carbon.device.mgt.iot.util.ZipArchive;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.plugin.xmpp.XmppConfig;
import org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl.util.APIUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class ZipUtil {
    private static final Log log = LogFactory.getLog(ZipUtil.class);
    private static final String HTTPS_PORT_PROPERTY = "httpsPort";
    private static final String HTTP_PORT_PROPERTY = "httpPort";
    private static final String LOCALHOST = "localhost";
    private static final String HTTPS_PROTOCOL_APPENDER = "https://";
    private static final String HTTP_PROTOCOL_APPENDER = "http://";
    private static final String CONFIG_TYPE = "general";
    private static final String DEFAULT_MQTT_ENDPOINT = "tcp://localhost:1883";

    public ZipArchive createZipFile(String owner, String deviceType, String deviceId, String deviceName, String apiApplicationKey, String token, String refreshToken) throws DeviceManagementException {
        String sketchFolder = "repository" + File.separator + "resources" + File.separator + "sketches";
        String archivesPath = CarbonUtils.getCarbonHome() + File.separator + sketchFolder + File.separator + "archives" + File.separator + deviceId;
        String templateSketchPath = sketchFolder + File.separator + deviceType;
        try {
            PlatformConfiguration configuration;
            String iotServerIP = Utils.getServerUrl();
            String httpsServerPort = System.getProperty(HTTPS_PORT_PROPERTY);
            String httpServerPort = System.getProperty(HTTP_PORT_PROPERTY);
            String httpsServerEP = HTTPS_PROTOCOL_APPENDER + iotServerIP + ":" + httpsServerPort;
            String httpServerEP = HTTP_PROTOCOL_APPENDER + iotServerIP + ":" + httpServerPort;
            String mqttEndpoint = DEFAULT_MQTT_ENDPOINT;
            if (mqttEndpoint.contains(LOCALHOST)) {
                mqttEndpoint = mqttEndpoint.replace(LOCALHOST, iotServerIP);
            }
            String xmppEndpoint = "";
            if (XmppConfig.getInstance().isEnabled() && (xmppEndpoint = XmppConfig.getInstance().getHost() + ":" + XmppConfig.getInstance().getPort()).contains(LOCALHOST)) {
                xmppEndpoint = xmppEndpoint.replace(LOCALHOST, iotServerIP);
            }
            if ((configuration = APIUtil.getTenantConfigurationManagementService().getConfiguration(CONFIG_TYPE)) != null && configuration.getConfiguration() != null && configuration.getConfiguration().size() > 0) {
                List configurations = configuration.getConfiguration();
                for (ConfigurationEntry configurationEntry : configurations) {
                    switch (configurationEntry.getName()) {
                        case "VIRTUAL_FIREALARM_HTTPS_EP": {
                            httpsServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_HTTP_EP": {
                            httpServerEP = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_MQTT_EP": {
                            mqttEndpoint = (String)configurationEntry.getValue();
                            break;
                        }
                        case "VIRTUAL_FIREALARM_XMPP_EP": {
                            xmppEndpoint = (String)configurationEntry.getValue();
                        }
                    }
                }
            }
            String base64EncodedApplicationKey = this.getBase64EncodedAPIAppKey(apiApplicationKey).trim();
            HashMap<String, String> contextParams = new HashMap<String, String>();
            contextParams.put("TENANT_DOMAIN", APIUtil.getTenantDomainOftheUser());
            contextParams.put("DEVICE_OWNER", owner);
            contextParams.put("DEVICE_ID", deviceId);
            contextParams.put("DEVICE_NAME", deviceName);
            contextParams.put("HTTPS_EP", httpsServerEP);
            contextParams.put("HTTP_EP", httpServerEP);
            contextParams.put("APIM_EP", httpServerEP);
            contextParams.put("MQTT_EP", mqttEndpoint);
            contextParams.put("XMPP_EP", "XMPP:" + xmppEndpoint);
            contextParams.put("API_APPLICATION_KEY", base64EncodedApplicationKey);
            contextParams.put("DEVICE_TOKEN", token);
            contextParams.put("DEVICE_REFRESH_TOKEN", refreshToken);
            contextParams.put("SERVER_NAME", XmppConfig.getInstance().getServerName() == null ? "" : XmppConfig.getInstance().getServerName());
            contextParams.put("SERVER_JID", XmppConfig.getInstance().getJid() == null ? "" : XmppConfig.getInstance().getJid());
            ZipArchive zipFile = Utils.getSketchArchive((String)archivesPath, (String)templateSketchPath, contextParams, (String)deviceName);
            return zipFile;
        }
        catch (IOException e) {
            throw new DeviceManagementException("Zip File Creation Failed", (Exception)e);
        }
        catch (ConfigurationManagementException e) {
            throw new DeviceManagementException("Failed to retrieve configuration", (Exception)((Object)e));
        }
    }

    private String getBase64EncodedAPIAppKey(String apiAppCredentialsAsJSONString) {
        JSONObject jsonObject = new JSONObject(apiAppCredentialsAsJSONString);
        String consumerKey = jsonObject.get("client_id").toString();
        String consumerSecret = jsonObject.get("client_secret").toString();
        String stringToEncode = consumerKey + ":" + consumerSecret;
        return Base64.encodeBase64String((byte[])stringToEncode.getBytes());
    }
}

