/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.virtualfirealarm.service.impl;

import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.wso2.carbon.apimgt.annotations.api.API;
import org.wso2.carbon.apimgt.annotations.api.Permission;
import org.wso2.carbon.device.mgt.extensions.feature.mgt.annotations.DeviceType;
import org.wso2.carbon.device.mgt.extensions.feature.mgt.annotations.Feature;

@API(name="virtual_firealarm", version="1.0.0", context="/virtual_firealarm", tags={"virtual_firealarm"})
@DeviceType(value="virtual_firealarm")
public interface VirtualFireAlarmService {
    @POST
    @Path(value="device/{deviceId}/buzz")
    @Permission(scope="virtual_firealarm_user", permissions={"/permission/admin/device-mgt/user/operations"})
    @Feature(code="buzz", name="Buzzer On / Off", description="Switch on/off Virtual Fire Alarm Buzzer. (On / Off)")
    public Response switchBuzzer(@PathParam(value="deviceId") String var1, @FormParam(value="state") String var2);

    @Path(value="device/stats/{deviceId}")
    @GET
    @Permission(scope="virtual_firealarm_user", permissions={"/permission/admin/device-mgt/user/stats"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getVirtualFirealarmStats(@PathParam(value="deviceId") String var1, @QueryParam(value="from") long var2, @QueryParam(value="to") long var4);

    @Path(value="device/download")
    @GET
    @Produces(value={"application/zip"})
    @Permission(scope="virtual_firealarm_user", permissions={"/permission/admin/device-mgt/user/devices"})
    public Response downloadSketch(@QueryParam(value="deviceName") String var1, @QueryParam(value="sketchType") String var2);
}

