/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.util;

import java.util.HashMap;
import java.util.Map;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebSocketSessionRequest {
    private static final Log log = LogFactory.getLog(WebSocketSessionRequest.class);
    private static final String QUERY_STRING_SEPERATOR = "&";
    private static final String QUERY_KEY_VALUE_SEPERATOR = "=";
    private Map<String, String> queryParamValuePairs = null;
    private Session session;

    public WebSocketSessionRequest(Session session) {
        this.session = session;
        this.setQueryParamValuePairs();
    }

    public Map<String, String> getQueryParamValuePairs() {
        return this.queryParamValuePairs;
    }

    public Session getSession() {
        return this.session;
    }

    private void setQueryParamValuePairs() {
        if (this.session.getQueryString() != null) {
            String[] allQueryParamPairs;
            String queryString = this.session.getQueryString();
            for (String keyValuePair : allQueryParamPairs = queryString.split(QUERY_STRING_SEPERATOR)) {
                String[] thisQueryParamPair = keyValuePair.split(QUERY_KEY_VALUE_SEPERATOR);
                if (thisQueryParamPair.length != 2) {
                    log.warn((Object)("Invalid query string [" + queryString + "] passed in."));
                    break;
                }
                if (this.queryParamValuePairs == null) {
                    this.queryParamValuePairs = new HashMap<String, String>();
                }
                this.queryParamValuePairs.put(thisQueryParamPair[0], thisQueryParamPair[1]);
            }
        }
    }
}

