/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.UIEventAdapterFactory;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.UIOutputCallbackControllerService;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.UIOutputCallbackControllerServiceImpl;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.Authenticator;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authorization.Authorizer;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.WebsocketConfig;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.WebsocketValidationConfigurationFailedException;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.internal.UIEventAdaptorServiceDataHolder;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.service.WebsocketValidationService;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.service.WebsocketValidationServiceImpl;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.stream.core.EventStreamService;

public class UILocalEventAdapterServiceComponent {
    private static final Log log = LogFactory.getLog(UILocalEventAdapterServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            UIEventAdapterFactory uiEventAdapterFactory = new UIEventAdapterFactory();
            context.getBundleContext().registerService(OutputEventAdapterFactory.class.getName(), (Object)uiEventAdapterFactory, null);
            UIOutputCallbackControllerServiceImpl UIOutputCallbackRegisterServiceImpl = new UIOutputCallbackControllerServiceImpl();
            context.getBundleContext().registerService(UIOutputCallbackControllerService.class.getName(), (Object)UIOutputCallbackRegisterServiceImpl, null);
            UIEventAdaptorServiceDataHolder.registerUIOutputCallbackRegisterServiceInternal(UIOutputCallbackRegisterServiceImpl);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the output ui adapter service");
            }
            try {
                WebsocketConfig.getInstance().init();
                WebsocketValidationServiceImpl websocketValidationService = new WebsocketValidationServiceImpl();
                String authenticatorClassName = WebsocketConfig.getInstance().getWebsocketValidationConfigs().getAuthenticator().getClazz();
                String authorizerClassName = WebsocketConfig.getInstance().getWebsocketValidationConfigs().getAuthorizer().getClazz();
                if (authenticatorClassName != null && !authenticatorClassName.isEmpty()) {
                    Class<Authenticator> authenticatorClass = Class.forName(authenticatorClassName).asSubclass(Authenticator.class);
                    Authenticator authenticator = authenticatorClass.newInstance();
                    websocketValidationService.setAuthenticator(authenticator);
                }
                if (authorizerClassName != null && !authorizerClassName.isEmpty()) {
                    Class<Authorizer> authorizerClass = Class.forName(authorizerClassName).asSubclass(Authorizer.class);
                    Authorizer authorizer = authorizerClass.newInstance();
                    websocketValidationService.setAuthorizer(authorizer);
                }
                context.getBundleContext().registerService(WebsocketValidationService.class.getName(), (Object)websocketValidationService, null);
            }
            catch (WebsocketValidationConfigurationFailedException e) {
                log.error((Object)"Failed to initialize configuration for websocket.", (Throwable)e);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error((Object)"Failed to initialize the class authentication and authorization given in the websocket validation configuration.", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the output ui adapter service ", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating UI Event Adapter Service Component", e);
        }
    }

    protected void setEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the EventStreamService reference for the UILocalEventAdaptor Service");
        }
        UIEventAdaptorServiceDataHolder.registerEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-Setting the EventStreamService reference for the UILocalEventAdaptor Service");
        }
        UIEventAdaptorServiceDataHolder.registerEventStreamService(null);
    }
}

