/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.config;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.WebsocketValidationConfigs;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.WebsocketValidationConfigurationFailedException;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.util.WebsocketUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class WebsocketConfig {
    private static WebsocketConfig config = new WebsocketConfig();
    private WebsocketValidationConfigs websocketValidationConfigs;
    private static final String WEBSOCKET_VALIDATION_CONFIG_PATH = CarbonUtils.getEtcCarbonConfigDirPath() + File.separator + "websocket-validation.xml";

    private WebsocketConfig() {
    }

    public static WebsocketConfig getInstance() {
        return config;
    }

    public void init() throws WebsocketValidationConfigurationFailedException {
        try {
            File deviceMgtConfig = new File(WEBSOCKET_VALIDATION_CONFIG_PATH);
            Document doc = WebsocketUtils.convertToDocument(deviceMgtConfig);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{WebsocketValidationConfigs.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            this.websocketValidationConfigs = (WebsocketValidationConfigs)unmarshaller.unmarshal((Node)doc);
        }
        catch (JAXBException e) {
            throw new WebsocketValidationConfigurationFailedException("Error occurred while un-marshalling Websocket Config", (Exception)((Object)e));
        }
    }

    public WebsocketValidationConfigs getWebsocketValidationConfigs() {
        return this.websocketValidationConfigs;
    }

    public void setWebsocketValidationConfigs(WebsocketValidationConfigs websocketValidationConfigs) {
    }
}

