/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.authorization;

import java.util.Map;
import javax.websocket.Session;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.AuthenticationInfo;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authorization.Authorizer;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.util.WebSocketSessionRequest;

public class DeviceAuthorizer
implements Authorizer {
    private static final String STATS_SCOPE_IDENTIFIER = "stats";
    private static final String DEVICE_MGT_SCOPE_IDENTIFIER = "device-mgt";

    @Override
    public boolean isAuthorized(AuthenticationInfo authenticationInfo, Session session, String stream) {
        WebSocketSessionRequest webSocketSessionRequest = new WebSocketSessionRequest(session);
        Map<String, String> queryParams = webSocketSessionRequest.getQueryParamValuePairs();
        String deviceId = queryParams.get("deviceId");
        String deviceType = queryParams.get("deviceType");
        Object scopeObject = authenticationInfo.getProperties().get("scopes");
        if (deviceId != null && !deviceId.isEmpty() && deviceType != null && !deviceType.isEmpty() && scopeObject != null) {
            String[] scopes = (String[])scopeObject;
            String requiredScope = "device-mgt:" + deviceType + ":" + deviceId + ":" + STATS_SCOPE_IDENTIFIER;
            for (String scope : scopes) {
                if (!requiredScope.equals(scope)) continue;
                return true;
            }
        }
        return false;
    }
}

