/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.oauth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.oauth.exception.OAuthTokenValidationException;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;

public class OAuthTokenValidaterStubFactory
extends BasePoolableObjectFactory {
    private static final Log log = LogFactory.getLog(OAuthTokenValidaterStubFactory.class);
    private HttpClient httpClient;
    Properties tokenValidationProperties;

    public OAuthTokenValidaterStubFactory(Properties tokenValidationProperties) {
        this.tokenValidationProperties = tokenValidationProperties;
        this.httpClient = this.createHttpClient();
    }

    public Object makeObject() throws Exception {
        return this.generateStub();
    }

    public void passivateObject(Object o) throws Exception {
        if (o instanceof OAuth2TokenValidationServiceStub) {
            OAuth2TokenValidationServiceStub stub = (OAuth2TokenValidationServiceStub)o;
            stub._getServiceClient().cleanupTransport();
        }
    }

    private OAuth2TokenValidationServiceStub generateStub() throws OAuthTokenValidationException {
        OAuth2TokenValidationServiceStub stub;
        block6: {
            try {
                URL hostURL = new URL(this.tokenValidationProperties.getProperty("tokenValidationEndpoint"));
                if (hostURL != null) {
                    stub = new OAuth2TokenValidationServiceStub(hostURL.toString());
                    if (stub != null) {
                        ServiceClient client = stub._getServiceClient();
                        client.getServiceContext().getConfigurationContext().setProperty("CACHED_HTTP_CLIENT", (Object)this.httpClient);
                        HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
                        auth.setPreemptiveAuthentication(true);
                        String username = this.tokenValidationProperties.getProperty("username");
                        String password = this.tokenValidationProperties.getProperty("password");
                        auth.setPassword(username);
                        auth.setUsername(password);
                        Options options = client.getOptions();
                        options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
                        options.setProperty("REUSE_HTTP_CLIENT", (Object)"true");
                        client.setOptions(options);
                        if (hostURL.getProtocol().equals("https")) {
                            EasySSLProtocolSocketFactory sslProtocolSocketFactory = this.createProtocolSocketFactory();
                            Protocol authhttps = new Protocol(hostURL.getProtocol(), (ProtocolSocketFactory)sslProtocolSocketFactory, hostURL.getPort());
                            Protocol.registerProtocol((String)hostURL.getProtocol(), (Protocol)authhttps);
                            options.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)authhttps);
                        }
                        break block6;
                    }
                    String errorMsg = "OAuth Validation instanization failed.";
                    throw new OAuthTokenValidationException(errorMsg);
                }
                String errorMsg = "host url is invalid";
                throw new OAuthTokenValidationException(errorMsg);
            }
            catch (AxisFault axisFault) {
                throw new OAuthTokenValidationException("Error occurred while creating the OAuth2TokenValidationServiceStub.", (Exception)((Object)axisFault));
            }
            catch (MalformedURLException e) {
                throw new OAuthTokenValidationException("Error occurred while parsing token endpoint URL", e);
            }
        }
        return stub;
    }

    private EasySSLProtocolSocketFactory createProtocolSocketFactory() throws OAuthTokenValidationException {
        try {
            EasySSLProtocolSocketFactory easySSLPSFactory = new EasySSLProtocolSocketFactory();
            return easySSLPSFactory;
        }
        catch (IOException e) {
            String errorMsg = "Failed to initiate EasySSLProtocolSocketFactory.";
            throw new OAuthTokenValidationException(errorMsg, e);
        }
        catch (GeneralSecurityException e) {
            String errorMsg = "Failed to set the key material in easy ssl factory.";
            throw new OAuthTokenValidationException(errorMsg, e);
        }
    }

    private HttpClient createHttpClient() {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(Integer.parseInt(this.tokenValidationProperties.getProperty("maximumHttpConnectionPerHost")));
        params.setMaxTotalConnections(Integer.parseInt(this.tokenValidationProperties.getProperty("maximumTotalHttpConnection")));
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        return new HttpClient((HttpConnectionManager)connectionManager);
    }
}

