/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.oauth;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.websocket.Session;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.AuthenticationInfo;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.authentication.oauth.OAuthTokenValidaterStubFactory;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.Property;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.config.WebsocketConfig;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_OAuth2AccessToken;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthTokenValdiator {
    private static String cookie;
    private GenericObjectPool stubs;
    private static Log log;
    private static final String WEBSOCKET_CONFIG_LOCATION;
    private static final String QUERY_STRING_SEPERATOR = "&";
    private static final String QUERY_KEY_VALUE_SEPERATOR = "=";
    private static final String TOKEN_TYPE = "bearer";
    private static final String TOKEN_IDENTIFIER = "token";
    private static OAuthTokenValdiator oAuthTokenValdiator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthTokenValdiator getInstance() {
        if (oAuthTokenValdiator != null) return oAuthTokenValdiator;
        Class<OAuthTokenValdiator> clazz = OAuthTokenValdiator.class;
        synchronized (OAuthTokenValdiator.class) {
            if (oAuthTokenValdiator != null) return oAuthTokenValdiator;
            oAuthTokenValdiator = new OAuthTokenValdiator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return oAuthTokenValdiator;
        }
    }

    private OAuthTokenValdiator() {
        try {
            Properties properties = this.getWebSocketConfig();
            this.stubs = new GenericObjectPool((PoolableObjectFactory)new OAuthTokenValidaterStubFactory(properties));
        }
        catch (IOException e) {
            log.error((Object)("Failed to parse the web socket org.wso2.carbon.device.mgt.iot.output.adapter.ui.config file " + WEBSOCKET_CONFIG_LOCATION), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationInfo validateToken(Session session) {
        String token = this.getTokenFromSession(session);
        if (token == null) {
            AuthenticationInfo authenticationInfo = new AuthenticationInfo();
            authenticationInfo.setAuthenticated(false);
            return authenticationInfo;
        }
        OAuth2TokenValidationServiceStub tokenValidationServiceStub = null;
        try {
            Object stub = this.stubs.borrowObject();
            if (stub != null) {
                tokenValidationServiceStub = (OAuth2TokenValidationServiceStub)stub;
                if (cookie != null) {
                    tokenValidationServiceStub._getServiceClient().getOptions().setProperty("Cookie", (Object)cookie);
                }
                AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(token, tokenValidationServiceStub);
                return authenticationInfo;
            }
            log.warn((Object)"Stub initialization failed.");
        }
        catch (RemoteException e) {
            log.error((Object)"Error on connecting with the validation endpoint.", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred in borrowing an validation stub from the pool.", (Throwable)e);
        }
        finally {
            try {
                if (tokenValidationServiceStub != null) {
                    this.stubs.returnObject((Object)tokenValidationServiceStub);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error occurred while returning the object back to the oauth token validation service stub pool.", (Throwable)e);
            }
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setAuthenticated(false);
        return authenticationInfo;
    }

    private AuthenticationInfo getAuthenticationInfo(String token, OAuth2TokenValidationServiceStub tokenValidationServiceStub) throws RemoteException, UserStoreException {
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        OAuth2TokenValidationRequestDTO validationRequest = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO_OAuth2AccessToken accessToken = new OAuth2TokenValidationRequestDTO_OAuth2AccessToken();
        accessToken.setTokenType(TOKEN_TYPE);
        accessToken.setIdentifier(token);
        validationRequest.setAccessToken(accessToken);
        OAuth2TokenValidationResponseDTO tokenValidationResponse = tokenValidationServiceStub.validate(validationRequest);
        if (tokenValidationResponse == null) {
            authenticationInfo.setAuthenticated(false);
            return authenticationInfo;
        }
        boolean authenticated = tokenValidationResponse.getValid();
        if (authenticated) {
            String authorizedUser = tokenValidationResponse.getAuthorizedUser();
            String username = MultitenantUtils.getTenantAwareUsername((String)authorizedUser);
            String tenantDomain = MultitenantUtils.getTenantDomain((String)authorizedUser);
            authenticationInfo.setUsername(username);
            authenticationInfo.setTenantDomain(tenantDomain);
            String[] scopes = tokenValidationResponse.getScope();
            if (scopes != null) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("scopes", scopes);
                authenticationInfo.setProperties(properties);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Token validation failed for token: " + token));
        }
        ServiceContext serviceContext = tokenValidationServiceStub._getServiceClient().getLastOperationContext().getServiceContext();
        cookie = (String)serviceContext.getProperty("Cookie");
        authenticationInfo.setAuthenticated(authenticated);
        return authenticationInfo;
    }

    private Properties getWebSocketConfig() throws IOException {
        Properties properties = new Properties();
        List<Property> propertyList = WebsocketConfig.getInstance().getWebsocketValidationConfigs().getAuthenticator().getProperties().getProperty();
        for (Property property : propertyList) {
            properties.put(property.getName(), property.getValue());
        }
        return properties;
    }

    private String getTokenFromSession(Session session) {
        String queryString = session.getQueryString();
        if (queryString != null) {
            String[] allQueryParamPairs;
            for (String keyValuePair : allQueryParamPairs = queryString.split(QUERY_STRING_SEPERATOR)) {
                String[] queryParamPair = keyValuePair.split(QUERY_KEY_VALUE_SEPERATOR);
                if (queryParamPair.length != 2) {
                    log.warn((Object)("Invalid query string [" + queryString + "] passed in."));
                    break;
                }
                if (!queryParamPair[0].equals(TOKEN_IDENTIFIER)) continue;
                return queryParamPair[1];
            }
        }
        return null;
    }

    static {
        log = LogFactory.getLog(OAuthTokenValdiator.class);
        WEBSOCKET_CONFIG_LOCATION = CarbonUtils.getEtcCarbonConfigDirPath() + File.separator + "websocket-validation.properties";
    }
}

