/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import javax.websocket.Session;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.UIOutputCallbackControllerService;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.internal.UIEventAdaptorServiceDataHolder;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.util.WebSocketSessionRequest;

public class UIOutputCallbackControllerServiceImpl
implements UIOutputCallbackControllerService {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, CopyOnWriteArrayList<WebSocketSessionRequest>>> outputEventAdaptorSessionMap = new ConcurrentHashMap();

    @Override
    public void subscribeWebsocket(String streamName, String version, Session session) {
        CopyOnWriteArrayList<WebSocketSessionRequest> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (version == null || " ".equals(version)) {
            version = "1.0.0";
        }
        String streamId = streamName + ":" + version;
        ConcurrentHashMap<String, CopyOnWriteArrayList<WebSocketSessionRequest>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap == null) {
            tenantSpecificAdaptorMap = new ConcurrentHashMap();
            if (null != this.outputEventAdaptorSessionMap.putIfAbsent(tenantId, tenantSpecificAdaptorMap)) {
                tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
            }
        }
        if ((adapterSpecificSessions = tenantSpecificAdaptorMap.get(streamId)) == null && null != tenantSpecificAdaptorMap.putIfAbsent(streamId, adapterSpecificSessions = new CopyOnWriteArrayList())) {
            adapterSpecificSessions = tenantSpecificAdaptorMap.get(streamId);
        }
        WebSocketSessionRequest webSocketSessionUtil = new WebSocketSessionRequest(session);
        adapterSpecificSessions.add(webSocketSessionUtil);
    }

    public CopyOnWriteArrayList<WebSocketSessionRequest> getSessions(int tenantId, String streamId) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<WebSocketSessionRequest>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null) {
            return tenantSpecificAdaptorMap.get(streamId);
        }
        return null;
    }

    public LinkedBlockingDeque<Object> getEvents(int tenanId, String streamName, String version) {
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> tenantSpecificStreamMap = UIEventAdaptorServiceDataHolder.getTenantSpecificStreamEventMap().get(tenanId);
        if (tenantSpecificStreamMap != null) {
            String streamId = streamName + ":" + version;
            return tenantSpecificStreamMap.get(streamId);
        }
        return null;
    }

    @Override
    public void unsubscribeWebsocket(String streamName, String version, Session session) {
        CopyOnWriteArrayList<WebSocketSessionRequest> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (version == null || " ".equals(version)) {
            version = "1.0.0";
        }
        String id = streamName + ":" + version;
        ConcurrentHashMap<String, CopyOnWriteArrayList<WebSocketSessionRequest>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null && (adapterSpecificSessions = tenantSpecificAdaptorMap.get(id)) != null) {
            WebSocketSessionRequest sessionToRemove = null;
            for (WebSocketSessionRequest webSocketSessionUtil : adapterSpecificSessions) {
                if (!session.getId().equals(webSocketSessionUtil.getSession().getId())) continue;
                sessionToRemove = webSocketSessionUtil;
                break;
            }
            if (sessionToRemove != null) {
                adapterSpecificSessions.remove(sessionToRemove);
            }
        }
    }
}

