/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.ui;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.UIOutputCallbackControllerServiceImpl;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.internal.UIEventAdaptorServiceDataHolder;
import org.wso2.carbon.device.mgt.iot.output.adapter.ui.util.WebSocketSessionRequest;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class UIEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(UIEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private int queueSize;
    private LinkedBlockingDeque<Object> streamSpecificEvents;
    private static ThreadPoolExecutor executorService;
    private int tenantId;
    private boolean doLogDroppedMessage;
    private String streamId;
    private List<Attribute> streamMetaAttributes;
    private List<Attribute> streamCorrelationAttributes;
    private List<Attribute> streamPayloadAttributes;

    public UIEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.doLogDroppedMessage = true;
    }

    public void init() throws OutputEventAdapterException {
        String adapterName;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
        this.streamId = this.eventAdapterConfiguration.getOutputStreamIdOfWso2eventMessageFormat();
        if (this.streamId == null || this.streamId.isEmpty()) {
            throw new OutputEventAdapterRuntimeException("UI event adapter needs a output stream id");
        }
        StreamDefinition streamDefinition = this.getStreamDefinition(this.streamId);
        this.streamMetaAttributes = streamDefinition.getMetaData();
        this.streamCorrelationAttributes = streamDefinition.getCorrelationData();
        this.streamPayloadAttributes = streamDefinition.getPayloadData();
        ConcurrentHashMap<Integer, ConcurrentHashMap<String, String>> tenantSpecifcEventOutputAdapterMap = UIEventAdaptorServiceDataHolder.getTenantSpecificOutputEventStreamAdapterMap();
        ConcurrentHashMap<String, String> streamSpecifAdapterMap = tenantSpecifcEventOutputAdapterMap.get(this.tenantId);
        if (streamSpecifAdapterMap == null) {
            streamSpecifAdapterMap = new ConcurrentHashMap();
            if (null != tenantSpecifcEventOutputAdapterMap.putIfAbsent(this.tenantId, streamSpecifAdapterMap)) {
                streamSpecifAdapterMap = tenantSpecifcEventOutputAdapterMap.get(this.tenantId);
            }
        }
        if ((adapterName = streamSpecifAdapterMap.get(this.streamId)) != null) {
            throw new OutputEventAdapterException("An Output ui event adapter \"" + adapterName + "\" is already" + " exist for stream id \"" + this.streamId + "\"");
        }
        streamSpecifAdapterMap.put(this.streamId, this.eventAdapterConfiguration.getName());
        ConcurrentHashMap<Integer, ConcurrentHashMap<String, LinkedBlockingDeque<Object>>> tenantSpecificStreamMap = UIEventAdaptorServiceDataHolder.getTenantSpecificStreamEventMap();
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> streamSpecificEventsMap = tenantSpecificStreamMap.get(this.tenantId);
        if (streamSpecificEventsMap == null) {
            streamSpecificEventsMap = new ConcurrentHashMap();
            if (null != tenantSpecificStreamMap.putIfAbsent(this.tenantId, streamSpecificEventsMap)) {
                streamSpecificEventsMap = tenantSpecificStreamMap.get(this.tenantId);
            }
        }
        this.streamSpecificEvents = streamSpecificEventsMap.get(this.streamId);
        if (this.streamSpecificEvents == null) {
            this.streamSpecificEvents = new LinkedBlockingDeque();
            if (null != streamSpecificEventsMap.putIfAbsent(this.streamId, this.streamSpecificEvents)) {
                this.streamSpecificEvents = streamSpecificEventsMap.get(this.streamId);
            }
        }
        if (this.globalProperties.get("eventQueueSize") != null) {
            try {
                this.queueSize = Integer.parseInt(this.globalProperties.get("eventQueueSize"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("String does not have the appropriate format for conversion." + e.getMessage()));
                this.queueSize = 30;
            }
        } else {
            this.queueSize = 30;
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        int i;
        Event event = (Event)message;
        StringBuilder eventBuilder = new StringBuilder("[");
        if (this.streamSpecificEvents.size() == this.queueSize) {
            this.streamSpecificEvents.removeFirst();
        }
        eventBuilder.append(event.getTimeStamp());
        if (event.getMetaData() != null) {
            eventBuilder.append(",");
            Object[] metaData = event.getMetaData();
            for (i = 0; i < metaData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(metaData[i]);
                eventBuilder.append("\"");
                if (i == metaData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        if (event.getCorrelationData() != null) {
            Object[] correlationData = event.getCorrelationData();
            eventBuilder.append(",");
            for (i = 0; i < correlationData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(correlationData[i]);
                eventBuilder.append("\"");
                if (i == correlationData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        if (event.getPayloadData() != null) {
            Object[] payloadData = event.getPayloadData();
            eventBuilder.append(",");
            for (i = 0; i < payloadData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(payloadData[i]);
                eventBuilder.append("\"");
                if (i == payloadData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        eventBuilder.append("]");
        String eventString = eventBuilder.toString();
        Object[] eventValues = new Object[]{eventString, System.currentTimeMillis()};
        this.streamSpecificEvents.add(eventValues);
        CopyOnWriteArrayList<WebSocketSessionRequest> validSessions = this.getValidSessions(event);
        try {
            executorService.execute(new WebSocketSender(validSessions, eventString));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
    }

    public void destroy() {
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> tenantSpecificStreamEventMap;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, String> tenantSpecificAdapterMap = UIEventAdaptorServiceDataHolder.getTenantSpecificOutputEventStreamAdapterMap().get(tenantId);
        if (tenantSpecificAdapterMap != null && this.streamId != null) {
            tenantSpecificAdapterMap.remove(this.streamId);
        }
        if ((tenantSpecificStreamEventMap = UIEventAdaptorServiceDataHolder.getTenantSpecificStreamEventMap().get(tenantId)) != null && this.streamId != null) {
            tenantSpecificStreamEventMap.remove(this.streamId);
        }
    }

    public boolean isPolled() {
        return true;
    }

    private StreamDefinition getStreamDefinition(String streamId) throws OutputEventAdapterException {
        EventStreamService eventStreamService = UIEventAdaptorServiceDataHolder.getEventStreamService();
        if (eventStreamService != null) {
            try {
                return eventStreamService.getStreamDefinition(streamId);
            }
            catch (EventStreamConfigurationException e) {
                String adaptorType = this.eventAdapterConfiguration.getType();
                String adaptorName = this.eventAdapterConfiguration.getName();
                String errorMsg = "Error while retrieving Stream-Definition for Stream with id [" + streamId + "] " + "for Adaptor [" + adaptorName + "] of type [" + adaptorType + "].";
                log.error((Object)errorMsg);
                throw new OutputEventAdapterException(errorMsg, (Throwable)e);
            }
        }
        throw new OutputEventAdapterException("Could not retrieve the EventStreamService whilst trying to fetch the Stream-Definition of Stream with Id [" + streamId + "].");
    }

    private CopyOnWriteArrayList<WebSocketSessionRequest> getValidSessions(Event event) {
        CopyOnWriteArrayList<WebSocketSessionRequest> validSessions = new CopyOnWriteArrayList<WebSocketSessionRequest>();
        UIOutputCallbackControllerServiceImpl uiOutputCallbackControllerServiceImpl = UIEventAdaptorServiceDataHolder.getUIOutputCallbackRegisterServiceImpl();
        CopyOnWriteArrayList<WebSocketSessionRequest> webSocketSessionUtils = uiOutputCallbackControllerServiceImpl.getSessions(this.tenantId, this.streamId);
        if (webSocketSessionUtils != null) {
            for (WebSocketSessionRequest webSocketSessionUtil : webSocketSessionUtils) {
                boolean isValidSession = this.validateEventAgainstSessionFilters(event, webSocketSessionUtil);
                if (!isValidSession) continue;
                validSessions.add(webSocketSessionUtil);
            }
        }
        return validSessions;
    }

    private boolean validateEventAgainstSessionFilters(Event event, WebSocketSessionRequest webSocketSessionUtil) {
        Map<String, String> queryParamValuePairs = webSocketSessionUtil.getQueryParamValuePairs();
        if (queryParamValuePairs != null) {
            String queryValue;
            String attributeName;
            int i;
            Object[] eventMetaData = event.getMetaData();
            Object[] eventCorrelationData = event.getCorrelationData();
            Object[] eventPayloadData = event.getPayloadData();
            if (this.streamMetaAttributes != null) {
                for (i = 0; i < this.streamMetaAttributes.size(); ++i) {
                    attributeName = this.streamMetaAttributes.get(i).getName();
                    queryValue = queryParamValuePairs.get(attributeName);
                    if (queryValue == null || eventMetaData != null && eventMetaData[i].toString().equals(queryValue)) continue;
                    return false;
                }
            }
            if (this.streamCorrelationAttributes != null) {
                for (i = 0; i < this.streamCorrelationAttributes.size(); ++i) {
                    attributeName = this.streamCorrelationAttributes.get(i).getName();
                    queryValue = queryParamValuePairs.get(attributeName);
                    if (queryValue == null || eventCorrelationData != null && eventCorrelationData[i].toString().equals(queryValue)) continue;
                    return false;
                }
            }
            if (this.streamPayloadAttributes != null) {
                for (i = 0; i < this.streamPayloadAttributes.size(); ++i) {
                    attributeName = this.streamPayloadAttributes.get(i).getName();
                    queryValue = queryParamValuePairs.get(attributeName);
                    if (queryValue == null || eventPayloadData != null && eventPayloadData[i].toString().equals(queryValue)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private class WebSocketSender
    implements Runnable {
        private String message;
        private CopyOnWriteArrayList<WebSocketSessionRequest> webSocketSessionUtils;

        public WebSocketSender(CopyOnWriteArrayList<WebSocketSessionRequest> webSocketSessionUtils, String message) {
            this.webSocketSessionUtils = webSocketSessionUtils;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (this.webSocketSessionUtils == null) {
                if (!UIEventAdapter.this.doLogDroppedMessage) return;
                EventAdapterUtil.logAndDrop((String)UIEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"No clients registered", (Log)log, (int)UIEventAdapter.this.tenantId);
                UIEventAdapter.this.doLogDroppedMessage = false;
                return;
            }
            UIEventAdapter.this.doLogDroppedMessage = true;
            Iterator<WebSocketSessionRequest> i$ = this.webSocketSessionUtils.iterator();
            while (i$.hasNext()) {
                WebSocketSessionRequest webSocketSessionUtil = i$.next();
                Class<WebSocketSessionRequest> clazz = WebSocketSessionRequest.class;
                // MONITORENTER : org.wso2.carbon.device.mgt.iot.output.adapter.ui.util.WebSocketSessionRequest.class
                try {
                    webSocketSessionUtil.getSession().getBasicRemote().sendText(this.message);
                }
                catch (IOException e) {
                    EventAdapterUtil.logAndDrop((String)UIEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send to endpoint", (Throwable)e, (Log)log, (int)UIEventAdapter.this.tenantId);
                }
            }
        }
    }
}

