/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.util.XMPPServerConnectionConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;

public class XMPPAdapterPublisher {
    private static final Log log = LogFactory.getLog(XMPPAdapterPublisher.class);
    private XMPPServerConnectionConfiguration xmppServerConnectionConfiguration;
    XMPPConnection xmppConnection;

    public XMPPAdapterPublisher(XMPPServerConnectionConfiguration xmppServerConnectionConfiguration) {
        this.xmppServerConnectionConfiguration = xmppServerConnectionConfiguration;
        this.connect();
    }

    public void connect() {
        SmackConfiguration.setPacketReplyTimeout((int)this.xmppServerConnectionConfiguration.getTimeoutInterval());
        ConnectionConfiguration config = new ConnectionConfiguration(this.xmppServerConnectionConfiguration.getHost(), this.xmppServerConnectionConfiguration.getPort());
        config.setSASLAuthenticationEnabled(false);
        config.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
        this.xmppConnection = new XMPPConnection(config);
        String resource = this.xmppServerConnectionConfiguration.getResource();
        String username = this.xmppServerConnectionConfiguration.getUsername();
        String password = this.xmppServerConnectionConfiguration.getPassword();
        try {
            this.xmppConnection.connect();
            if (resource == null || resource.trim().isEmpty()) {
                this.xmppConnection.login(username, password);
            } else {
                this.xmppConnection.login(username, password, resource);
            }
        }
        catch (XMPPException e) {
            String errorMsg = "Login attempt to the XMPP Server  with username - " + username + " failed.";
            log.info((Object)errorMsg);
            throw new OutputEventAdapterRuntimeException(errorMsg, (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.xmppConnection.isConnected();
    }

    public void publish(String JID, String subject, String message, String messageType) {
        Message xmppMessage = new Message();
        xmppMessage.setTo(JID);
        xmppMessage.setSubject(subject);
        xmppMessage.setBody(message);
        if (messageType != null) {
            switch (messageType) {
                case "chat": {
                    xmppMessage.setType(Message.Type.chat);
                    break;
                }
                case "groupchat": {
                    xmppMessage.setType(Message.Type.groupchat);
                    break;
                }
                case "error": {
                    xmppMessage.setType(Message.Type.error);
                    break;
                }
                case "headline": {
                    xmppMessage.setType(Message.Type.headline);
                    break;
                }
                default: {
                    xmppMessage.setType(Message.Type.normal);
                    break;
                }
            }
        } else {
            xmppMessage.setType(Message.Type.normal);
        }
        this.xmppConnection.sendPacket((Packet)xmppMessage);
    }

    public void close() throws OutputEventAdapterException {
        if (this.xmppConnection != null && this.isConnected()) {
            this.xmppConnection.disconnect();
        }
    }
}

