/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.xmpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.XMPPEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;

public class XMPPEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "xmpp";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        supportedMessageFormats.add("text");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property host = new Property("host");
        host.setDisplayName(this.resourceBundle.getString("host"));
        host.setRequired(true);
        host.setHint(this.resourceBundle.getString("host.hint"));
        Property port = new Property("port");
        port.setDisplayName(this.resourceBundle.getString("port"));
        port.setRequired(true);
        port.setHint(this.resourceBundle.getString("port.hint"));
        Property userName = new Property("username");
        userName.setDisplayName(this.resourceBundle.getString("username"));
        userName.setRequired(true);
        userName.setHint(this.resourceBundle.getString("username.hint"));
        Property password = new Property("password");
        password.setDisplayName(this.resourceBundle.getString("password"));
        password.setRequired(true);
        password.setHint(this.resourceBundle.getString("password.hint"));
        Property timooutInterval = new Property("timeoutInterval");
        timooutInterval.setDisplayName(this.resourceBundle.getString("timeoutInterval.hint"));
        timooutInterval.setRequired(false);
        timooutInterval.setHint(this.resourceBundle.getString("timeoutInterval.hint"));
        Property resource = new Property("resource");
        resource.setDisplayName(this.resourceBundle.getString("resource"));
        resource.setRequired(false);
        resource.setHint(this.resourceBundle.getString("resource.hint"));
        staticPropertyList.add(host);
        staticPropertyList.add(port);
        staticPropertyList.add(userName);
        staticPropertyList.add(password);
        staticPropertyList.add(timooutInterval);
        staticPropertyList.add(resource);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property jidProperty = new Property("jid");
        jidProperty.setDisplayName(this.resourceBundle.getString("jid.hint"));
        jidProperty.setRequired(true);
        Property subjectProperty = new Property("subject");
        subjectProperty.setDisplayName(this.resourceBundle.getString("subject.hint"));
        subjectProperty.setRequired(false);
        Property messageType = new Property("messageType");
        messageType.setDisplayName(this.resourceBundle.getString("messageType.hint"));
        messageType.setRequired(true);
        messageType.setOptions(new String[]{"chat", "error", "groupchat", "normal", "headline"});
        messageType.setDefaultValue("normal");
        dynamicPropertyList.add(jidProperty);
        dynamicPropertyList.add(subjectProperty);
        dynamicPropertyList.add(messageType);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new XMPPEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

