/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.xmpp;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.util.XMPPAdapterPublisher;
import org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.util.XMPPServerConnectionConfiguration;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class XMPPEventAdapter
implements OutputEventAdapter {
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private XMPPAdapterPublisher xmppAdapterPublisher;
    private static ThreadPoolExecutor threadPoolExecutor;
    private static final Log log;
    private int tenantId;

    public XMPPEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (threadPoolExecutor == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            threadPoolExecutor = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        int xmppPort = 5222;
        String xmppPortString = (String)this.eventAdapterConfiguration.getStaticProperties().get("port");
        if (xmppPortString != null && !xmppPortString.trim().isEmpty()) {
            xmppPort = Integer.parseInt(xmppPortString);
        }
        int timeoutInterval = 5000;
        String timeoutIntervalString = (String)this.eventAdapterConfiguration.getStaticProperties().get("timeoutInterval");
        if (timeoutIntervalString != null && !timeoutIntervalString.trim().isEmpty()) {
            timeoutInterval = Integer.parseInt(timeoutIntervalString);
        }
        XMPPServerConnectionConfiguration xmppServerConnectionConfiguration = new XMPPServerConnectionConfiguration((String)this.eventAdapterConfiguration.getStaticProperties().get("host"), xmppPort, (String)this.eventAdapterConfiguration.getStaticProperties().get("username"), (String)this.eventAdapterConfiguration.getStaticProperties().get("password"), timeoutInterval, (String)this.eventAdapterConfiguration.getStaticProperties().get("resource"));
        this.xmppAdapterPublisher = new XMPPAdapterPublisher(xmppServerConnectionConfiguration);
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String jid = dynamicProperties.get("jid");
        String subject = dynamicProperties.get("subject");
        String messageType = dynamicProperties.get("messageType");
        try {
            threadPoolExecutor.submit(new XMPPSender(jid, subject, (String)message, messageType));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        try {
            if (this.xmppAdapterPublisher != null) {
                this.xmppAdapterPublisher.close();
                this.xmppAdapterPublisher = null;
            }
        }
        catch (OutputEventAdapterException e) {
            log.error((Object)("Exception when closing the mqtt publisher connection on Output MQTT Adapter '" + this.eventAdapterConfiguration.getName() + "'"), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    static {
        log = LogFactory.getLog(XMPPEventAdapter.class);
    }

    class XMPPSender
    implements Runnable {
        String jid;
        String subject;
        String message;
        String messageType;

        XMPPSender(String jid, String subject, String message, String messageType) {
            this.jid = jid;
            this.message = message;
            this.subject = subject;
            this.messageType = messageType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                if (!XMPPEventAdapter.this.xmppAdapterPublisher.isConnected()) {
                    Class<XMPPEventAdapter> clazz = XMPPEventAdapter.class;
                    // MONITORENTER : org.wso2.carbon.device.mgt.iot.output.adapter.xmpp.XMPPEventAdapter.class
                    if (!XMPPEventAdapter.this.xmppAdapterPublisher.isConnected()) {
                        XMPPEventAdapter.this.xmppAdapterPublisher.connect();
                    }
                    // MONITOREXIT : clazz
                }
                XMPPEventAdapter.this.xmppAdapterPublisher.publish(this.jid, this.subject, this.message, this.messageType);
                return;
            }
            catch (Throwable t) {
                EventAdapterUtil.logAndDrop((String)XMPPEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, null, (Throwable)t, (Log)log, (int)XMPPEventAdapter.this.tenantId);
            }
        }
    }
}

