/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.jwt.client.extension.service.JWTClientManagerService;

public class MQTTUtil {
    private static final String HTTPS_PROTOCOL = "https";
    private static final Log log = LogFactory.getLog(MQTTUtil.class);

    public static HttpClient getHttpClient(String protocol) throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient httpclient;
        if (HTTPS_PROTOCOL.equals(protocol)) {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        } else {
            httpclient = HttpClients.createDefault();
        }
        return httpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseString(HttpResponse httpResponse) throws IOException {
        BufferedReader br = null;
        try {
            String readLine;
            br = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            String response = "";
            while ((readLine = br.readLine()) != null) {
                response = response + readLine;
            }
            String string = response;
            return string;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error while closing the connection! " + e.getMessage()));
                }
            }
        }
    }

    public static JWTClientManagerService getJWTClientManagerService() {
        PrivilegedCarbonContext ctx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        JWTClientManagerService jwtClientManagerService = (JWTClientManagerService)ctx.getOSGiService(JWTClientManagerService.class, null);
        if (jwtClientManagerService == null) {
            String msg = "JWT management service has not initialized.";
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return jwtClientManagerService;
    }
}

