/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util.MQTTBrokerConnectionConfiguration;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util.MQTTUtil;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util.RegistrationProfile;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.identity.jwt.client.extension.dto.AccessTokenInfo;
import org.wso2.carbon.identity.jwt.client.extension.exception.JWTClientException;
import org.wso2.carbon.identity.jwt.client.extension.service.JWTClientManagerService;

public class MQTTAdapterPublisher {
    private static final Log log = LogFactory.getLog(MQTTAdapterPublisher.class);
    private MqttClient mqttClient;
    private MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration;
    String clientId;

    public MQTTAdapterPublisher(MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration, String clientId) {
        if (clientId == null || clientId.trim().isEmpty()) {
            this.clientId = MqttClient.generateClientId();
        }
        this.mqttBrokerConnectionConfiguration = mqttBrokerConnectionConfiguration;
        this.connect();
    }

    public void connect() {
        if (this.clientId == null || this.clientId.trim().isEmpty()) {
            this.clientId = MqttClient.generateClientId();
        }
        boolean cleanSession = this.mqttBrokerConnectionConfiguration.isCleanSession();
        int keepAlive = this.mqttBrokerConnectionConfiguration.getKeepAlive();
        String temp_directory = System.getProperty("java.io.tmpdir");
        MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(temp_directory);
        try {
            MqttConnectOptions connectionOptions = new MqttConnectOptions();
            connectionOptions.setCleanSession(cleanSession);
            connectionOptions.setKeepAliveInterval(keepAlive);
            if (this.mqttBrokerConnectionConfiguration.getBrokerUsername() != null) {
                connectionOptions.setUserName(this.getToken(this.mqttBrokerConnectionConfiguration.getBrokerUsername(), this.mqttBrokerConnectionConfiguration.getDcrUrl(), this.mqttBrokerConnectionConfiguration.getScopes()));
                connectionOptions.setPassword("".toCharArray());
            }
            this.mqttClient = new MqttClient(this.mqttBrokerConnectionConfiguration.getBrokerUrl(), this.clientId, (MqttClientPersistence)dataStore);
            this.mqttClient.connect(connectionOptions);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when constructing MQTT client for broker url : " + this.mqttBrokerConnectionConfiguration.getBrokerUrl()), (Throwable)e);
            this.handleException(e);
        }
    }

    public boolean isConnected() {
        return this.mqttClient.isConnected();
    }

    public void publish(int qos, String payload, String topic) {
        try {
            MqttMessage message = new MqttMessage(payload.getBytes());
            message.setQos(qos);
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when publishing message for MQTT server : " + this.mqttClient.getServerURI()), (Throwable)e);
            this.handleException(e);
        }
    }

    public void publish(String payload, String topic) {
        try {
            MqttMessage message = new MqttMessage(payload.getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when publishing message for MQTT server : " + this.mqttClient.getServerURI()), (Throwable)e);
            this.handleException(e);
        }
    }

    public void close() throws OutputEventAdapterException {
        try {
            this.mqttClient.disconnect(1000L);
            this.mqttClient.close();
        }
        catch (MqttException e) {
            throw new OutputEventAdapterException((Throwable)e);
        }
    }

    private void handleException(MqttException e) {
        if (e.getReasonCode() == 32104) {
            throw new ConnectionUnavailableException((Throwable)e);
        }
        throw new OutputEventAdapterRuntimeException((Throwable)e);
    }

    private String getToken(String username, String dcrUrlString, String scopes) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
        if (dcrUrlString != null && !dcrUrlString.isEmpty()) {
            try {
                URL dcrUrl = new URL(dcrUrlString);
                HttpClient httpClient = MQTTUtil.getHttpClient(dcrUrl.getProtocol());
                HttpPost postMethod = new HttpPost(dcrUrlString);
                RegistrationProfile registrationProfile = new RegistrationProfile();
                registrationProfile.setCallbackUrl("");
                registrationProfile.setGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer refresh_token");
                registrationProfile.setOwner(username);
                registrationProfile.setTokenScope("production");
                registrationProfile.setApplicationType("device");
                registrationProfile.setClientName(username + "_" + tenantId);
                String jsonString = registrationProfile.toJSON();
                StringEntity requestEntity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
                postMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)postMethod);
                String response = MQTTUtil.getResponseString(httpResponse);
                try {
                    JSONParser jsonParser = new JSONParser();
                    JSONObject jsonPayload = (JSONObject)jsonParser.parse(response);
                    String clientId = (String)jsonPayload.get((Object)"client_id");
                    String clientSecret = (String)jsonPayload.get((Object)"client_secret");
                    JWTClientManagerService jwtClientManagerService = MQTTUtil.getJWTClientManagerService();
                    AccessTokenInfo accessTokenInfo = jwtClientManagerService.getJWTClient().getAccessToken(clientId, clientSecret, username, scopes);
                    return accessTokenInfo.getAccessToken();
                }
                catch (ParseException e) {
                    String msg = "error occurred while parsing client credential payload";
                    throw new OutputEventAdapterRuntimeException(msg, (Throwable)e);
                }
                catch (JWTClientException e) {
                    String msg = "error occurred while parsing the response from JWT Client";
                    throw new OutputEventAdapterRuntimeException(msg, (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                throw new OutputEventAdapterRuntimeException("Invalid dcrUrl : " + dcrUrlString);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new OutputEventAdapterRuntimeException("Failed to create an https connection.", (Throwable)e);
            }
        }
        throw new OutputEventAdapterRuntimeException("Invalid configuration for mqtt publisher");
    }
}

