/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.MQTTEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;

public class MQTTEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "oauth-mqtt";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        supportedMessageFormats.add("text");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property brokerUrl = new Property("url");
        brokerUrl.setDisplayName(this.resourceBundle.getString("url"));
        brokerUrl.setRequired(true);
        brokerUrl.setHint(this.resourceBundle.getString("url.hint"));
        Property userName = new Property("username");
        userName.setDisplayName(this.resourceBundle.getString("username"));
        userName.setRequired(true);
        userName.setHint(this.resourceBundle.getString("username.hint"));
        Property dcrUrl = new Property("dcrUrl");
        dcrUrl.setDisplayName(this.resourceBundle.getString("dcrUrl"));
        dcrUrl.setRequired(true);
        dcrUrl.setHint(this.resourceBundle.getString("dcrUrl.hint"));
        Property scopes = new Property("scopes");
        scopes.setDisplayName(this.resourceBundle.getString("scopes"));
        scopes.setRequired(true);
        scopes.setHint(this.resourceBundle.getString("scopes.hint"));
        Property clientId = new Property("clientId");
        clientId.setDisplayName(this.resourceBundle.getString("clientId"));
        clientId.setRequired(false);
        clientId.setHint(this.resourceBundle.getString("clientId.hint"));
        staticPropertyList.add(clientId);
        Property clearSession = new Property("cleanSession");
        clearSession.setDisplayName(this.resourceBundle.getString("cleanSession"));
        clearSession.setRequired(false);
        clearSession.setOptions(new String[]{"true", "false"});
        clearSession.setDefaultValue("true");
        clearSession.setHint(this.resourceBundle.getString("cleanSession.hint"));
        Property qos = new Property("qos");
        qos.setDisplayName(this.resourceBundle.getString("qos"));
        qos.setRequired(true);
        qos.setOptions(new String[]{"0", "1", "2"});
        qos.setDefaultValue("1");
        staticPropertyList.add(brokerUrl);
        staticPropertyList.add(userName);
        staticPropertyList.add(dcrUrl);
        staticPropertyList.add(scopes);
        staticPropertyList.add(clearSession);
        staticPropertyList.add(qos);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property topicProperty = new Property("topic");
        topicProperty.setDisplayName(this.resourceBundle.getString("topic"));
        topicProperty.setRequired(true);
        dynamicPropertyList.add(topicProperty);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new MQTTEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

