/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.output.adapter.mqtt;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util.MQTTAdapterPublisher;
import org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.util.MQTTBrokerConnectionConfiguration;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class MQTTEventAdapter
implements OutputEventAdapter {
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private MQTTAdapterPublisher mqttAdapterPublisher;
    private int connectionKeepAliveInterval;
    private String qos;
    private static ThreadPoolExecutor threadPoolExecutor;
    private static final Log log;
    private int tenantId;

    public MQTTEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        String keeAliveInternal = globalProperties.get("connectionKeepAliveInterval");
        if (keeAliveInternal != null) {
            try {
                this.connectionKeepAliveInterval = Integer.parseInt(keeAliveInternal.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)"Error when configuring user specified connection keep alive time, using default value", (Throwable)e);
                this.connectionKeepAliveInterval = 60;
            }
        } else {
            this.connectionKeepAliveInterval = 60;
        }
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
        if (threadPoolExecutor == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            threadPoolExecutor = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration = new MQTTBrokerConnectionConfiguration((String)this.eventAdapterConfiguration.getStaticProperties().get("url"), (String)this.eventAdapterConfiguration.getStaticProperties().get("username"), (String)this.eventAdapterConfiguration.getStaticProperties().get("dcrUrl"), (String)this.eventAdapterConfiguration.getStaticProperties().get("scopes"), this.connectionKeepAliveInterval, (String)this.eventAdapterConfiguration.getStaticProperties().get("cleanSession"));
        String clientId = (String)this.eventAdapterConfiguration.getStaticProperties().get("clientId");
        this.qos = (String)this.eventAdapterConfiguration.getStaticProperties().get("qos");
        this.mqttAdapterPublisher = new MQTTAdapterPublisher(mqttBrokerConnectionConfiguration, clientId);
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String topic = dynamicProperties.get("topic");
        try {
            threadPoolExecutor.submit(new MQTTSender(topic, message));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        try {
            if (this.mqttAdapterPublisher != null) {
                this.mqttAdapterPublisher.close();
                this.mqttAdapterPublisher = null;
            }
        }
        catch (OutputEventAdapterException e) {
            log.error((Object)("Exception when closing the mqtt publisher connection on Output MQTT Adapter '" + this.eventAdapterConfiguration.getName() + "'"), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    static {
        log = LogFactory.getLog(MQTTEventAdapter.class);
    }

    class MQTTSender
    implements Runnable {
        String topic;
        Object message;

        MQTTSender(String topic, Object message) {
            this.topic = topic;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                if (!MQTTEventAdapter.this.mqttAdapterPublisher.isConnected()) {
                    Class<MQTTEventAdapter> clazz = MQTTEventAdapter.class;
                    // MONITORENTER : org.wso2.carbon.device.mgt.iot.output.adapter.mqtt.MQTTEventAdapter.class
                    if (!MQTTEventAdapter.this.mqttAdapterPublisher.isConnected()) {
                        MQTTEventAdapter.this.mqttAdapterPublisher.connect();
                    }
                    // MONITOREXIT : clazz
                }
                if (MQTTEventAdapter.this.qos != null && !MQTTEventAdapter.this.qos.trim().isEmpty()) {
                    MQTTEventAdapter.this.mqttAdapterPublisher.publish(Integer.parseInt(MQTTEventAdapter.this.qos), this.message.toString(), this.topic);
                    return;
                }
                MQTTEventAdapter.this.mqttAdapterPublisher.publish(this.message.toString(), this.topic);
                return;
            }
            catch (Throwable t) {
                EventAdapterUtil.logAndDrop((String)MQTTEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, null, (Throwable)t, (Log)log, (int)MQTTEventAdapter.this.tenantId);
            }
        }
    }
}

