/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentInfo;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentValidator;

public class MQTTContentValidator
implements ContentValidator {
    private static final String JSON_ARRAY_START_CHAR = "[";
    private static final Log log = LogFactory.getLog(MQTTContentValidator.class);

    public ContentInfo validate(Object msgPayload, Map<String, Object> dynamicParams) {
        String topic = (String)dynamicParams.get("topic");
        String[] topics = topic.split("/");
        String deviceIdJsonPath = "event.metaData.deviceId";
        int deviceIdInTopicHierarchyLevelIndex = 2;
        String deviceIdFromTopic = topics[deviceIdInTopicHierarchyLevelIndex];
        String message = (String)msgPayload;
        boolean status = message.startsWith(JSON_ARRAY_START_CHAR) ? this.processMultipleEvents(message, deviceIdFromTopic, deviceIdJsonPath) : this.processSingleEvent(message, deviceIdFromTopic, deviceIdJsonPath);
        return new ContentInfo(status, msgPayload);
    }

    private boolean processSingleEvent(String msg, String deviceIdFromTopic, String deviceIdJsonPath) {
        String deviceIdFromContent;
        Object res = JsonPath.read((String)msg, (String)deviceIdJsonPath, (Filter[])new Filter[0]);
        String string = deviceIdFromContent = res != null ? res.toString() : "";
        return deviceIdFromContent.equals(deviceIdFromTopic);
    }

    private boolean processMultipleEvents(String msg, String deviceIdFromTopic, String deviceIdJsonPath) {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONArray jsonArray = (JSONArray)jsonParser.parse(msg);
            boolean status = false;
            for (int i = 0; i < jsonArray.size(); ++i) {
                status = this.processSingleEvent(jsonArray.get(i).toString(), deviceIdFromTopic, deviceIdJsonPath);
                if (status) continue;
                return false;
            }
            return status;
        }
        catch (ParseException e) {
            log.error((Object)("Invalid input " + msg), (Throwable)e);
            return false;
        }
    }
}

