/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentInfo;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.exception.MQTTContentInitializationException;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util.MQTTBrokerConnectionConfiguration;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util.MQTTUtil;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util.RegistrationProfile;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.identity.jwt.client.extension.dto.AccessTokenInfo;
import org.wso2.carbon.identity.jwt.client.extension.exception.JWTClientException;
import org.wso2.carbon.identity.jwt.client.extension.service.JWTClientManagerService;

public class MQTTAdapterListener
implements MqttCallback,
Runnable {
    private static final Log log = LogFactory.getLog(MQTTAdapterListener.class);
    private MqttClient mqttClient;
    private MqttConnectOptions connectionOptions;
    private boolean cleanSession;
    private boolean connectionInitialized;
    private MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration;
    private String topic;
    private int tenantId;
    private boolean connectionSucceeded;
    ContentValidator contentValidator;
    ContentTransformer contentTransformer;
    private InputEventAdapterListener eventAdapterListener;

    public MQTTAdapterListener(MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration, String topic, String mqttClientId, InputEventAdapterListener inputEventAdapterListener, int tenantId) {
        block15: {
            this.connectionSucceeded = false;
            this.eventAdapterListener = null;
            if (mqttClientId == null || mqttClientId.trim().isEmpty()) {
                mqttClientId = MqttClient.generateClientId();
            }
            this.mqttBrokerConnectionConfiguration = mqttBrokerConnectionConfiguration;
            this.cleanSession = mqttBrokerConnectionConfiguration.isCleanSession();
            int keepAlive = mqttBrokerConnectionConfiguration.getKeepAlive();
            this.topic = topic;
            this.eventAdapterListener = inputEventAdapterListener;
            this.tenantId = tenantId;
            String temp_directory = System.getProperty("java.io.tmpdir");
            MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(temp_directory);
            try {
                this.connectionOptions = new MqttConnectOptions();
                this.connectionOptions.setCleanSession(this.cleanSession);
                this.connectionOptions.setKeepAliveInterval(keepAlive);
                this.mqttClient = new MqttClient(this.mqttBrokerConnectionConfiguration.getBrokerUrl(), mqttClientId, (MqttClientPersistence)dataStore);
                this.mqttClient.setCallback((MqttCallback)this);
                String contentValidatorClassName = this.mqttBrokerConnectionConfiguration.getContentValidatorClassName();
                if (contentValidatorClassName != null && contentValidatorClassName.equals("default")) {
                    this.contentValidator = new DefaultContentValidator();
                } else if (contentValidatorClassName != null && !contentValidatorClassName.isEmpty()) {
                    try {
                        Class<ContentValidator> contentValidatorClass = Class.forName(contentValidatorClassName).asSubclass(ContentValidator.class);
                        this.contentValidator = contentValidatorClass.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new MQTTContentInitializationException("Unable to find the class validator: " + contentValidatorClassName, e);
                    }
                    catch (InstantiationException e) {
                        throw new MQTTContentInitializationException("Unable to create an instance of :" + contentValidatorClassName, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new MQTTContentInitializationException("Access of the instance in not allowed.", e);
                    }
                }
                String contentTransformerClassName = this.mqttBrokerConnectionConfiguration.getContentTransformerClassName();
                if (contentTransformerClassName != null && contentTransformerClassName.equals("default")) {
                    this.contentTransformer = new DefaultContentTransformer();
                    break block15;
                }
                if (contentTransformerClassName == null || contentTransformerClassName.isEmpty()) break block15;
                try {
                    Class<ContentTransformer> contentTransformerClass = Class.forName(contentTransformerClassName).asSubclass(ContentTransformer.class);
                    this.contentTransformer = contentTransformerClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new MQTTContentInitializationException("Unable to find the class transfoer: " + contentTransformerClassName, e);
                }
                catch (InstantiationException e) {
                    throw new MQTTContentInitializationException("Unable to create an instance of :" + contentTransformerClassName, e);
                }
                catch (IllegalAccessException e) {
                    throw new MQTTContentInitializationException("Access of the instance in not allowed.", e);
                }
            }
            catch (MqttException e) {
                log.error((Object)("Exception occurred while subscribing to MQTT broker at " + mqttBrokerConnectionConfiguration.getBrokerUrl()));
                throw new InputEventAdapterRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListener() throws MqttException {
        block13: {
            if (this.mqttBrokerConnectionConfiguration.getBrokerUsername() != null && this.mqttBrokerConnectionConfiguration.getDcrUrl() != null) {
                String username = this.mqttBrokerConnectionConfiguration.getBrokerUsername();
                String dcrUrlString = this.mqttBrokerConnectionConfiguration.getDcrUrl();
                String scopes = this.mqttBrokerConnectionConfiguration.getBrokerScopes();
                if (dcrUrlString != null && !dcrUrlString.isEmpty()) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(username);
                    try {
                        URL dcrUrl = new URL(dcrUrlString);
                        HttpClient httpClient = MQTTUtil.getHttpClient(dcrUrl.getProtocol());
                        HttpPost postMethod = new HttpPost(dcrUrlString);
                        RegistrationProfile registrationProfile = new RegistrationProfile();
                        registrationProfile.setCallbackUrl("");
                        registrationProfile.setGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer refresh_token");
                        registrationProfile.setOwner(username);
                        registrationProfile.setTokenScope("production");
                        registrationProfile.setApplicationType("device");
                        registrationProfile.setClientName(username + "_" + this.tenantId);
                        String jsonString = registrationProfile.toJSON();
                        StringEntity requestEntity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
                        postMethod.setEntity((HttpEntity)requestEntity);
                        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)postMethod);
                        if (httpResponse == null) break block13;
                        String response = MQTTUtil.getResponseString(httpResponse);
                        try {
                            if (response != null) {
                                JSONParser jsonParser = new JSONParser();
                                JSONObject jsonPayload = (JSONObject)jsonParser.parse(response);
                                String clientId = (String)jsonPayload.get((Object)"client_id");
                                String clientSecret = (String)jsonPayload.get((Object)"client_secret");
                                JWTClientManagerService jwtClientManagerService = MQTTUtil.getJWTClientManagerService();
                                AccessTokenInfo accessTokenInfo = jwtClientManagerService.getJWTClient().getAccessToken(clientId, clientSecret, username, scopes);
                                this.connectionOptions.setUserName(accessTokenInfo.getAccessToken());
                            }
                        }
                        catch (ParseException e) {
                            String msg = "error occurred while parsing client credential payload";
                            log.error((Object)msg, (Throwable)e);
                        }
                        catch (JWTClientException e) {
                            String msg = "error occurred while parsing the response from JWT Client";
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)("Invalid dcrUrl : " + dcrUrlString));
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                        log.error((Object)"Failed to create an https connection.", (Throwable)e);
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
            }
        }
        this.mqttClient.connect(this.connectionOptions);
        this.mqttClient.subscribe(this.topic);
    }

    public void stopListener(String adapterName) {
        if (this.connectionSucceeded) {
            try {
                if (!ServerStatus.getCurrentStatus().equals("SHUTTING_DOWN") || this.cleanSession) {
                    this.mqttClient.unsubscribe(this.topic);
                }
                this.mqttClient.disconnect(3000L);
            }
            catch (MqttException e) {
                log.error((Object)("Can not unsubscribe from the destination " + this.topic + " with the event adapter " + adapterName), (Throwable)e);
            }
        }
        this.connectionSucceeded = true;
    }

    public void connectionLost(Throwable throwable) {
        log.warn((Object)("MQTT connection not reachable " + throwable));
        this.connectionSucceeded = false;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        try {
            String msgText = mqttMessage.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)msgText);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event received in MQTT Event Adapter - " + msgText));
            }
            if (this.contentValidator != null && this.contentTransformer != null) {
                HashMap<String, String> dynamicProperties = new HashMap<String, String>();
                dynamicProperties.put("topic", topic);
                msgText = (String)this.contentTransformer.transform((Object)msgText, dynamicProperties);
                ContentInfo contentInfo = this.contentValidator.validate((Object)msgText, dynamicProperties);
                if (contentInfo != null && contentInfo.isValidContent()) {
                    this.eventAdapterListener.onEvent(contentInfo.getMessage());
                }
            } else {
                this.eventAdapterListener.onEvent((Object)msgText);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    @Override
    public void run() {
        int connectionDuration = 4000;
        while (!this.connectionSucceeded) {
            try {
                Thread.sleep(connectionDuration *= 2);
                this.startListener();
                this.connectionSucceeded = true;
                log.info((Object)"MQTT Connection successful");
            }
            catch (InterruptedException e) {
                log.error((Object)"Interruption occurred while waiting for reconnection", (Throwable)e);
            }
            catch (MqttException e) {
                log.error((Object)"MQTT Exception occurred when starting listener", (Throwable)e);
            }
        }
    }

    public void createConnection() {
        this.connectionInitialized = true;
        new Thread(this).start();
    }

    public boolean isConnectionInitialized() {
        return this.connectionInitialized;
    }
}

