/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.MQTTEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;

public class MQTTEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "oauth-mqtt";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("wso2event");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property topicProperty = new Property("topic");
        topicProperty.setDisplayName(this.resourceBundle.getString("topic"));
        topicProperty.setRequired(true);
        topicProperty.setHint(this.resourceBundle.getString("topic.hint"));
        propertyList.add(topicProperty);
        Property brokerUrl = new Property("url");
        brokerUrl.setDisplayName(this.resourceBundle.getString("url"));
        brokerUrl.setRequired(true);
        brokerUrl.setHint(this.resourceBundle.getString("url.hint"));
        propertyList.add(brokerUrl);
        Property dcrUrl = new Property("dcrUrl");
        dcrUrl.setDisplayName(this.resourceBundle.getString("dcrUrl"));
        dcrUrl.setRequired(false);
        dcrUrl.setHint(this.resourceBundle.getString("dcrUrl.hint"));
        propertyList.add(dcrUrl);
        Property contentValidator = new Property("contentValidator");
        contentValidator.setDisplayName(this.resourceBundle.getString("contentValidator"));
        contentValidator.setRequired(false);
        contentValidator.setHint(this.resourceBundle.getString("contentValidator.hint"));
        contentValidator.setDefaultValue("default");
        propertyList.add(contentValidator);
        Property userName = new Property("username");
        userName.setDisplayName(this.resourceBundle.getString("username"));
        userName.setRequired(false);
        userName.setHint(this.resourceBundle.getString("username.hint"));
        propertyList.add(userName);
        Property scopes = new Property("scopes");
        scopes.setDisplayName(this.resourceBundle.getString("scopes"));
        scopes.setRequired(false);
        scopes.setHint(this.resourceBundle.getString("scopes.hint"));
        propertyList.add(scopes);
        Property clearSession = new Property("cleanSession");
        clearSession.setDisplayName(this.resourceBundle.getString("cleanSession"));
        clearSession.setRequired(false);
        clearSession.setOptions(new String[]{"true", "false"});
        clearSession.setDefaultValue("true");
        clearSession.setHint(this.resourceBundle.getString("cleanSession.hint"));
        propertyList.add(clearSession);
        Property contentTransformer = new Property("contentTransformer");
        contentTransformer.setDisplayName(this.resourceBundle.getString("contentTransformer"));
        contentTransformer.setRequired(false);
        contentTransformer.setHint(this.resourceBundle.getString("contentTransformer.hint"));
        contentTransformer.setDefaultValue("default");
        propertyList.add(contentTransformer);
        Property clientId = new Property("clientId");
        clientId.setDisplayName(this.resourceBundle.getString("clientId"));
        clientId.setRequired(false);
        clientId.setHint(this.resourceBundle.getString("clientId.hint"));
        propertyList.add(clientId);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new MQTTEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

