/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.mqtt;

import java.util.Map;
import java.util.UUID;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util.MQTTAdapterListener;
import org.wso2.carbon.device.mgt.iot.input.adapter.mqtt.util.MQTTBrokerConnectionConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;

public class MQTTEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdapterListener;
    private final String id = UUID.randomUUID().toString();
    private MQTTAdapterListener mqttAdapterListener;
    private MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration;

    public MQTTEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdapterListener) throws InputEventAdapterException {
        this.eventAdapterListener = eventAdapterListener;
        try {
            int keepAlive = this.globalProperties.get("keepAlive") != null ? Integer.parseInt(this.globalProperties.get("keepAlive")) : 60000;
            this.mqttBrokerConnectionConfiguration = new MQTTBrokerConnectionConfiguration((String)this.eventAdapterConfiguration.getProperties().get("url"), (String)this.eventAdapterConfiguration.getProperties().get("username"), (String)this.eventAdapterConfiguration.getProperties().get("scopes"), (String)this.eventAdapterConfiguration.getProperties().get("dcrUrl"), (String)this.eventAdapterConfiguration.getProperties().get("cleanSession"), keepAlive, (String)this.eventAdapterConfiguration.getProperties().get("contentValidator"), (String)this.eventAdapterConfiguration.getProperties().get("contentTransformer"));
            this.mqttAdapterListener = new MQTTAdapterListener(this.mqttBrokerConnectionConfiguration, (String)this.eventAdapterConfiguration.getProperties().get("topic"), (String)this.eventAdapterConfiguration.getProperties().get("clientId"), eventAdapterListener, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        }
        catch (Throwable t) {
            throw new InputEventAdapterException(t.getMessage(), t);
        }
    }

    private String[] splitOnFirst(String str, char c) {
        int idx = str.indexOf(c);
        String head = str.substring(0, idx);
        String tail = str.substring(idx + 1);
        return new String[]{head, tail};
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        if (!this.mqttAdapterListener.isConnectionInitialized()) {
            this.mqttAdapterListener.createConnection();
        }
    }

    public void disconnect() {
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MQTTEventAdapter.this.mqttAdapterListener != null) {
                        MQTTEventAdapter.this.mqttAdapterListener.stopListener(MQTTEventAdapter.this.eventAdapterConfiguration.getName());
                    }
                }
            });
            thread.start();
            thread.join(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTTEventAdapter)) {
            return false;
        }
        MQTTEventAdapter that = (MQTTEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return true;
    }

    public boolean isPolling() {
        return this.mqttAdapterListener.isConnectionInitialized();
    }
}

