/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.util;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentInfo;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.exception.XMPPContentInitializationException;
import org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.util.XMPPEventAdapterConstants;
import org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.util.XMPPServerConnectionConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;

public class XMPPAdapterListener
implements Runnable {
    private static final Log log = LogFactory.getLog(XMPPAdapterListener.class);
    private XMPPConnection xmppConnection;
    private XMPPServerConnectionConfiguration xmppServerConnectionConfiguration;
    private int tenantId;
    private boolean connectionSucceeded;
    private ContentValidator contentValidator;
    private ContentTransformer contentTransformer;
    private PacketListener packetListener;
    private boolean connectionInitialized;
    private InputEventAdapterListener eventAdapterListener;

    public XMPPAdapterListener(XMPPServerConnectionConfiguration xmppServerConnectionConfiguration, InputEventAdapterListener inputEventAdapterListener, int tenantId) {
        block14: {
            this.connectionSucceeded = false;
            this.eventAdapterListener = null;
            this.xmppServerConnectionConfiguration = xmppServerConnectionConfiguration;
            this.eventAdapterListener = inputEventAdapterListener;
            this.tenantId = tenantId;
            try {
                String contentValidatorClassName = this.xmppServerConnectionConfiguration.getContentValidatorClassName();
                if (contentValidatorClassName != null && contentValidatorClassName.equals("default")) {
                    this.contentValidator = new DefaultContentValidator();
                } else if (contentValidatorClassName != null && !contentValidatorClassName.isEmpty()) {
                    try {
                        Class<ContentValidator> contentValidatorClass = Class.forName(contentValidatorClassName).asSubclass(ContentValidator.class);
                        this.contentValidator = contentValidatorClass.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new XMPPContentInitializationException("Unable to find the class validator: " + contentValidatorClassName, e);
                    }
                    catch (InstantiationException e) {
                        throw new XMPPContentInitializationException("Unable to create an instance of :" + contentValidatorClassName, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new XMPPContentInitializationException("Access of the instance in not allowed.", e);
                    }
                }
                String contentTransformerClassName = this.xmppServerConnectionConfiguration.getContentTransformerClassName();
                if (contentTransformerClassName != null && contentTransformerClassName.equals("default")) {
                    this.contentTransformer = new DefaultContentTransformer();
                    break block14;
                }
                if (contentTransformerClassName == null || contentTransformerClassName.isEmpty()) break block14;
                try {
                    Class<ContentTransformer> contentTransformerClass = Class.forName(contentTransformerClassName).asSubclass(ContentTransformer.class);
                    this.contentTransformer = contentTransformerClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new XMPPContentInitializationException("Unable to find the class transformer: " + contentTransformerClassName, e);
                }
                catch (InstantiationException e) {
                    throw new XMPPContentInitializationException("Unable to create an instance of :" + contentTransformerClassName, e);
                }
                catch (IllegalAccessException e) {
                    throw new XMPPContentInitializationException("Access of the instance in not allowed.", e);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Exception occurred while subscribing to MQTT broker at " + xmppServerConnectionConfiguration.getHost()));
                throw new InputEventAdapterRuntimeException(e);
            }
        }
    }

    public void startListener() throws XMPPException {
        SmackConfiguration.setPacketReplyTimeout((int)this.xmppServerConnectionConfiguration.getTimeoutInterval());
        ConnectionConfiguration config = new ConnectionConfiguration(this.xmppServerConnectionConfiguration.getHost(), this.xmppServerConnectionConfiguration.getPort());
        config.setSASLAuthenticationEnabled(false);
        config.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
        this.xmppConnection = new XMPPConnection(config);
        this.xmppConnection.connect();
        String resource = this.xmppServerConnectionConfiguration.getResource();
        String username = this.xmppServerConnectionConfiguration.getUsername();
        String password = this.xmppServerConnectionConfiguration.getPassword();
        try {
            if (resource == null || resource.trim().isEmpty()) {
                this.xmppConnection.login(username, password);
            } else {
                this.xmppConnection.login(username, password, resource);
            }
            this.setFilterOnReceiver(this.xmppServerConnectionConfiguration.getJid());
        }
        catch (XMPPException e) {
            String errorMsg = "Login attempt to the XMPP Server  with username - " + username + " failed.";
            log.info((Object)errorMsg);
            throw new InputEventAdapterRuntimeException(errorMsg, (Throwable)e);
        }
    }

    public void stopListener(String adapterName) {
        if (this.connectionSucceeded) {
            if (!ServerStatus.getCurrentStatus().equals("SHUTTING_DOWN")) {
                this.xmppConnection.removePacketListener(this.packetListener);
            }
            this.xmppConnection.disconnect();
        }
        this.connectionSucceeded = true;
    }

    protected void setFilterOnReceiver(String receiverJID) {
        AndFilter packetFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Message.class), new ToContainsFilter(receiverJID)});
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                if (packet instanceof Message) {
                    final Message xmppMessage = (Message)packet;
                    Thread msgProcessThread = new Thread(){

                        @Override
                        public void run() {
                            XMPPAdapterListener.this.processIncomingMessage(xmppMessage);
                        }
                    };
                    msgProcessThread.start();
                }
            }
        };
        this.xmppConnection.addPacketListener(this.packetListener, (PacketFilter)packetFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message xmppMessage) {
        try {
            String from = xmppMessage.getFrom();
            String subject = xmppMessage.getSubject();
            String message = xmppMessage.getBody();
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event received in MQTT Event Adapter - " + message));
            }
            if (this.contentValidator != null && this.contentTransformer != null) {
                HashMap<String, String> dynamicParmaters = new HashMap<String, String>();
                dynamicParmaters.put("from", from);
                dynamicParmaters.put("subject", subject);
                message = (String)this.contentTransformer.transform((Object)message, dynamicParmaters);
                ContentInfo contentInfo = this.contentValidator.validate((Object)message, dynamicParmaters);
                if (contentInfo != null && contentInfo.isValidContent()) {
                    this.eventAdapterListener.onEvent(contentInfo.getMessage());
                }
            } else {
                this.eventAdapterListener.onEvent((Object)message);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void run() {
        while (!this.connectionSucceeded) {
            int connectionDuration = XMPPEventAdapterConstants.INITIAL_RECONNECTION_DURATION;
            try {
                Thread.sleep(connectionDuration *= 2);
                this.startListener();
                this.connectionSucceeded = true;
                log.info((Object)"XMPP Connection successful");
            }
            catch (InterruptedException e) {
                log.error((Object)"Interruption occurred while waiting for reconnection", (Throwable)e);
            }
            catch (XMPPException e) {
                log.error((Object)"XMPP Exception occurred when starting listener", (Throwable)e);
            }
        }
    }

    public void createConnection() {
        this.connectionInitialized = true;
        new Thread(this).start();
    }

    public boolean isConnectionInitialized() {
        return this.connectionInitialized;
    }
}

