/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.xmpp;

import java.util.Map;
import java.util.UUID;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.util.XMPPAdapterListener;
import org.wso2.carbon.device.mgt.iot.input.adapter.xmpp.util.XMPPServerConnectionConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;

public class XMPPEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdapterListener;
    private final String id = UUID.randomUUID().toString();
    private XMPPAdapterListener xmppAdapterListener;
    private XMPPServerConnectionConfiguration xmppServerConnectionConfiguration;

    public XMPPEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdapterListener) throws InputEventAdapterException {
        this.eventAdapterListener = eventAdapterListener;
        try {
            int xmppPort = 5222;
            String xmppPortString = (String)this.eventAdapterConfiguration.getProperties().get("port");
            if (xmppPortString != null && !xmppPortString.trim().isEmpty()) {
                xmppPort = Integer.parseInt(xmppPortString);
            }
            int timeoutInterval = 5000;
            String timeoutIntervalString = (String)this.eventAdapterConfiguration.getProperties().get("timeoutInterval");
            if (timeoutIntervalString != null && !timeoutIntervalString.trim().isEmpty()) {
                timeoutInterval = Integer.parseInt(timeoutIntervalString);
            }
            this.xmppServerConnectionConfiguration = new XMPPServerConnectionConfiguration((String)this.eventAdapterConfiguration.getProperties().get("host"), xmppPort, (String)this.eventAdapterConfiguration.getProperties().get("username"), (String)this.eventAdapterConfiguration.getProperties().get("password"), timeoutInterval, (String)this.eventAdapterConfiguration.getProperties().get("resource"), (String)this.eventAdapterConfiguration.getProperties().get("contentValidator"), (String)this.eventAdapterConfiguration.getProperties().get("jid"), (String)this.eventAdapterConfiguration.getProperties().get("contentTransformer"));
            this.xmppAdapterListener = new XMPPAdapterListener(this.xmppServerConnectionConfiguration, eventAdapterListener, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true));
        }
        catch (Throwable t) {
            throw new InputEventAdapterException(t.getMessage(), t);
        }
    }

    private String[] splitOnFirst(String str, char c) {
        int idx = str.indexOf(c);
        String head = str.substring(0, idx);
        String tail = str.substring(idx + 1);
        return new String[]{head, tail};
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        if (this.xmppAdapterListener.isConnectionInitialized()) {
            this.xmppAdapterListener.createConnection();
        }
    }

    public void disconnect() {
        if (this.xmppAdapterListener != null) {
            this.xmppAdapterListener.stopListener(this.eventAdapterConfiguration.getName());
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMPPEventAdapter)) {
            return false;
        }
        XMPPEventAdapter that = (XMPPEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return true;
    }

    public boolean isPolling() {
        return this.xmppAdapterListener.isConnectionInitialized();
    }
}

