/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http.util;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentInfo;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentValidator;

public class HTTPContentValidator
implements ContentValidator {
    private static final Log log = LogFactory.getLog(HTTPContentValidator.class);
    private static String JSON_ARRAY_START_CHAR = "[";
    private static String CDMF_SCOPE_PREFIX = "cdmf";
    private static String CDMF_SCOPE_SEPERATOR = "/";

    public ContentInfo validate(Object msgPayload, Map<String, Object> dynamicParams) {
        String deviceId = (String)dynamicParams.get("deviceId");
        String deviceType = (String)dynamicParams.get("deviceType");
        String msg = (String)msgPayload;
        String deviceIdJsonPath = "event.metaData.deviceId";
        boolean status = this.isValidDevice(deviceId, deviceType, dynamicParams);
        if (status) {
            status = msg.startsWith(JSON_ARRAY_START_CHAR) ? this.processMultipleEvents(msg, deviceId, deviceIdJsonPath) : this.processSingleEvent(msg, deviceId, deviceIdJsonPath);
        }
        return new ContentInfo(status, (Object)msg);
    }

    private boolean processSingleEvent(String msg, String deviceIdFromTopic, String deviceIdJsonPath) {
        String deviceIdFromContent;
        Object res = JsonPath.read((String)msg, (String)deviceIdJsonPath, (Filter[])new Filter[0]);
        String string = deviceIdFromContent = res != null ? res.toString() : "";
        return deviceIdFromContent.equals(deviceIdFromTopic);
    }

    private boolean processMultipleEvents(String msg, String deviceIdFromTopic, String deviceIdJsonPath) {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONArray jsonArray = (JSONArray)jsonParser.parse(msg);
            boolean status = false;
            for (int i = 0; i < jsonArray.size(); ++i) {
                status = this.processSingleEvent(jsonArray.get(i).toString(), deviceIdFromTopic, deviceIdJsonPath);
                if (status) continue;
                return status;
            }
            return status;
        }
        catch (ParseException e) {
            log.error((Object)("Invalid input " + msg), (Throwable)e);
            return false;
        }
    }

    private boolean isValidDevice(String deviceId, String deviceType, Map<String, Object> dynamicParams) {
        List scopes = (List)dynamicParams.get("scopes");
        if (scopes != null) {
            for (String scope : scopes) {
                String[] deviceIdInfo;
                if (!scope.startsWith(CDMF_SCOPE_PREFIX) || (deviceIdInfo = scope.split(CDMF_SCOPE_SEPERATOR)).length != 3 || !deviceId.equals(deviceIdInfo[2]) || !deviceType.equals(deviceIdInfo[1])) continue;
                return true;
            }
        }
        return false;
    }
}

